/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.ds.types;



import java.io.Serializable;

import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This class defines a structure which may be used to provide information about
 * the result of the processing performed by a post-disconnect plugin.
 */
@NotMutable()
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PostDisconnectPluginResult
       implements Serializable
{
  /**
   * A predefined result instance that indicates all processing completed
   * successfully.
   */
  public static final PostDisconnectPluginResult SUCCESS =
       new PostDisconnectPluginResult(true);



  /**
   * The serial version UID for this serializable class.
   */
  private static final long serialVersionUID = -4255986650298662738L;



  // Indicates whether the server should continue processing other
  // post-disconnect plugins.
  private final boolean continuePluginProcessing;



  /**
   * Creates a new post-disconnect plugin result with the provided information.
   *
   * @param  continuePluginProcessing  Indicates whether to continue processing
   *                                   other post-disconnect plugins for the
   *                                   connection.
   */
  public PostDisconnectPluginResult(final boolean continuePluginProcessing)
  {
    this.continuePluginProcessing = continuePluginProcessing;
  }



  /**
   * Indicates whether to continue processing other post-disconnect plugins for
   * the connection.
   *
   * @return  {@code true} if the server should continue processing other
   *          post-disconnect plugins for the connection, or {@code false} if
   *          not.
   */
  public boolean continuePluginProcessing()
  {
    return continuePluginProcessing;
  }



  /**
   * Retrieves a string representation of this post-disconnect plugin result.
   *
   * @return  A string representation of this post-disconnect plugin result.
   */
  @Override()
  public String toString()
  {
    final StringBuilder buffer = new StringBuilder();

    buffer.append("PostDisconnectPluginResult(continuePluginProcessing=");
    buffer.append(continuePluginProcessing);
    buffer.append(')');

    return buffer.toString();
  }
}
