/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.ds.types;



import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This enum defines a set of dependencies that may need to be satisfied by a
 * component which is to be invoked at server startup.
 */
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum StartupDependency
{
  /**
   * This dependency will be satisfied after the access control handler has been
   * initialized.
   */
  ACCESS_CONTROL,



  /**
   * This dependency will be satisfied after the alarm manager has been
   * initialized.
   */
  ALARMS,



  /**
   * This dependency will be satisfied after the alert handlers have been
   * initialized.
   */
  ALERT_HANDLERS,



  /**
   * This dependency will be satisfied after the backends have been initialized.
   */
  BACKENDS,



  /**
   * This dependency will be satisfied after the certificate mappers have been
   * initialized.
   */
  CERTIFICATE_MAPPERS,



  /**
   * This dependency will be satisfied after the change subscription handlers
   * have been initialized.
   */
  CHANGE_SUBSCRIPTION_HANDLERS,



  /**
   * This dependency will be satisfied after the client connection policies have
   * been initialized.
   */
  CLIENT_CONNECTION_POLICIES,



  /**
   * This dependency will be satisfied after the config audit log has been
   * initialized.
   */
  CONFIG_AUDIT_LOG,



  /**
   * This dependency will be satisfied after the connection handlers have been
   * initialized.
   */
  CONNECTION_HANDLERS_INITIALIZED,



  /**
   * This dependency will be satisfied after the connection handlers have been
   * started.
   */
  CONNECTION_HANDLER_STARTED,



  /**
   * This dependency will be satisfied after the core configuration (the
   * configuration properties associated with the "cn=config" entry itself) has
   * been initialized.
   */
  CORE_CONFIG,



  /**
   * This dependency will be satisfied after the criteria subsystem has been
   * initialized.
   */
  CRITERIA,



  /**
   * This dependency will be satisfied after the replication assurance policy
   * manager has been initialized.
   */
  REPLICATION_ASSURANCE_POLICIES,



  /**
   * This dependency will be satisfied after the crypto manager has been
   * initialized.
   */
  CRYPTO_MANAGER_INITIALIZED,



  /**
   * This dependency will be satisfied after crypto manager synchronization has
   * been enabled.
   */
  CRYPTO_MANAGER_SYNCHRONIZATION,



  /**
   * This dependency will be satisfied after the entry cache has been
   * initialized.
   */
  ENTRY_CACHE,



  /**
   * This dependency will be satisfied after the extended operation handlers
   * have been initialized.
   */
  EXTENDED_OPERATION_HANDLERS,



  /**
   * This dependency will be satisfied after the external servers have been
   * initialized.
   */
  EXTERNAL_SERVERS,



  /**
   * This dependency will be satisfied after gauges have been initialized.
   */
  GAUGES,



  /**
   * This dependency will be satisfied after the group implementations have
   * been initialized.
   */
  GROUPS,



  /**
   * This dependency will be satisfied after the identity mappers have been
   * initialized.
   */
  IDENTITY_MAPPERS,



  /**
   * This dependency will be satisfied after the key manager providers and trust
   * manager providers have been initialized.
   */
  KEY_AND_TRUST_MANAGERS,



  /**
   * This dependency will be satisfied after the locations have been
   * initialized.
   */
  LOCATIONS,



  /**
   * This dependency will be satisfied after the log rotation policies, log
   * retention policies, and log publishers have been initialized.
   */
  LOGGING,



  /**
   * This dependency will be satisfied after the log field mappings have been
   * initialized.
   */
  LOG_FIELD_MAPPINGS,



  /**
   * This dependency will be satisfied after the MIB providers have been
   * initialized.
   */
  MIB_PROVIDERS,



  /**
   * This dependency will be satisfied after the monitor providers have been
   * initialized.
   */
  MONITOR_PROVIDERS,



  /**
   * This dependency will be satisfied after the password policy components have
   * been initialized.
   */
  PASSWORD_POLICY,



  /**
   * This dependency will be satisfied after the plugins have been initialized.
   * Note that this will apply only for plugins that have not explicitly
   * overridden the set of startup dependencies.
   */
  PLUGINS,



  /**
   * This dependency will be satisfied after the proxy-related configuration has
   * been initialized.
   */
  PROXY_CONFIG,



  /**
   * This dependency will be satisfied after replication has been initialized.
   */
  REPLICATION,



  /**
   * This dependency will be satisfied after the synchronization server
   * components have been initialized.
   */
  SYNCHRONIZATION_SERVER,



  /**
   * This dependency will be satisfied after the SASL mechanism handlers have
   * been initialized.
   */
  SASL_MECHANISM_HANDLERS,



  /**
   * This dependency will be satisfied after all of the schema has been
   * initialized.
   */
  SCHEMA,



  /**
   * This dependency will be satisfied after all other startup processing has
   * completed.
   */
  STARTUP_COMPLETE,



  /**
   * This dependency will be satisfied after the subtree accessibility manager
   * has been initialized.
   */
  SUBTREE_ACCESSIBILITY,



  /**
   * This dependency will be satisfied after all the subtree views have been
   * initialized.
   */
  SUBTREE_VIEWS,



  /**
   * This dependency will be satisfied after the supported controls have been
   * initialized.
   */
  SUPPORTED_CONTROLS,



  /**
   * This dependency will be satisfied after the supported features have been
   * initialized.
   */
  SUPPORTED_FEATURES,



  /**
   * This dependency will be satisfied after the virtual attribute providers
   * have been initialized.
   */
  VIRTUAL_ATTRIBUTES,



  /**
   * This dependency will be satisfied after the work queue has been
   * initialized.
   */
  WORK_QUEUE;
}
