/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2012-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.ds.types;



import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This interface may be used to obtain information about the result of
 * processing a SASL bind operation in which a user has successfully completed
 * the authentication process.
 */
@NotExtensible()
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public interface SuccessSASLBindResult
       extends SASLBindResult
{
  /**
   * Retrieves the DN of the user that was successfully authenticated.
   *
   * @return  The DN of the user that was successfully authenticated, or
   *          an empty string if the authentication was anonymous.
   */
  String getAuthenticatedUserDN();



  /**
   * Retrieves the DN of the authorization identity resulting from the bind.
   *
   * @return  The DN of the authorization identity resulting from the bind, or
   *          an empty string if the authorization identity should be anonymous.
   */
  String getAuthorizedUserDN();



  /**
   * Retrieves the plaintext representation of the password used to
   * authenticate, if available.
   *
   * @return  The plaintext representation of the password used to authenticate,
   *          or {@code null} if this is not available or applicable.
   */
  ASN1OctetString getPasswordUsed();
}
