/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.ds.types;



import com.unboundid.directory.sdk.common.types.Entry;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This interface may be used to obtain information about an administrative
 * task which is being processed.
 */
@NotExtensible()
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public interface TaskContext
{
  /**
   * Retrieves the DN of the entry that contains the definition for this task.
   *
   * @return  The DN of the entry that contains the definition for this task.
   */
  String getTaskEntryDN();



  /**
   * Retrieves a read-only copy of the entry that contains the definition for
   * this task.
   *
   * @return  A read-only copy of the entry that contains the definition for
   *          this task.
   */
  Entry getTaskEntry();



  /**
   * Retrieves the unique identifier for this task.
   *
   * @return  The unique identifier for this task.
   */
  String getTaskID();



  /**
   * Retrieves information about the server in which the task is being
   * processed.
   *
   * @return  Information about the server in which the task is being processed.
   */
  DirectoryServerContext getServerContext();
}
