/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.ds.types;



import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This enum defines the states that a task may have after it has completed
 * processing.
 */
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum TaskReturnState
{
  /**
   * Indicates that the task completed all of its processing without any errors.
   */
  COMPLETED_SUCCESSFULLY,



  /**
   * Indicates that the task completed all of its processing but encountered one
   * or more errors in the process.
   */
  COMPLETED_WITH_ERRORS,



  /**
   * Indicates that the task was stopped prematurely because the server was
   * shutting down.
   */
  STOPPED_BY_SHUTDOWN,



  /**
   * Indicates that the task was stopped prematurely because an error occurred
   * during processing that made it unable to continue.
   */
  STOPPED_BY_ERROR,



  /**
   * Indicates that the task was stopped prematurely because it was canceled
   * by an administrator.
   */
  STOPPED_BY_ADMINISTRATOR;
}
