/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2011-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.http.config;



import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This interface defines a set of methods that may be used to obtain
 * information about the general configuration for an HTTP servlet extension.
 */
@NotExtensible()
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public interface HTTPServletExtensionConfig
       extends GenericHTTPConfig
{
  /**
   * Retrieves a handle to an object that may be used to interact with the HTTP
   * server itself.  This is provided for internal use only by
   * UnboundID-developed extensions, and no guarantee is made about either the
   * type of object, or the stability of the type of that object.
   *
   * @return  A handle to an object that may be used by UnboundID-developed
   *          extensions to interact with the HTTP server itself.
   */
  @InternalUseOnly()
  Object getHTTPServerObject();



  /**
   * Retrieves the DN of the configuration object for the HTTP connection
   * handler that created the servlet extension.
   *
   * @return  The DN of the configuration object for the HTTP connection handler
   *          that created the servlet extension.
   */
  String getHTTPConnectionHandlerConfigDN();
}
