/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2012-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.http.types;



import java.lang.reflect.Constructor;

import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This class provides a factory which may be used to obtain an of a
 * {@link WebAppServerContext} object.
 */
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class WebAppServerContextFactory
{
  /**
   * Obtain an instance of a {@link WebAppServerContext} object.  Note that this
   * may only be called by a web application running inside the server.
   *
   * @return  An instance of a {@code WebAppServerContext} object.
   */
  public static WebAppServerContext getServerContext()
  {
    try
    {
      final Class<?> genericProviderClass = Class.forName(
           "com.unboundid.directory.sdk.impl.ServerContextProvider");
      final Class<?> specificProviderClass = Class.forName(
           "com.unboundid.directory.sdk.impl.WebAppServerContextProvider");

      final Constructor<?> providerClassConstructor =
           specificProviderClass.getDeclaredConstructor();
      providerClassConstructor.setAccessible(true);
      final Object providerObject = providerClassConstructor.newInstance();

      final Class<?> implClass = Class.forName(
           "com.unboundid.directory.sdk.impl.ServerContextImpl");

      final Constructor<?> constructor =
           implClass.getConstructor(genericProviderClass);
      constructor.setAccessible(true);

      final Object o = constructor.newInstance(providerObject);
      return (WebAppServerContext) o;
    }
    catch (final Exception e)
    {
      throw new RuntimeException(
           "Unable to obtain an instance of a WebAppServerContext:  " +
                StaticUtils.getExceptionMessage(e),
           e);
    }
  }
}
