/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.proxy.internal;



import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This interface defines a set of methods that may be used to cause the
 * Directory Proxy Server to send search result entries and/or references to
 * the client in the course of processing a proxy transformation.
 */
@NotExtensible()
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public interface SearchResultProvider
{
  /**
   * Attempts to return the provided search result entry to the client.
   *
   * @param  entry                 The entry to return to the client.
   * @param  applyTransformations  Indicates whether to apply any configured
   *                               proxy transformations to the entry before
   *                               returning it to the client.
   *
   * @return  {@code true} if the caller may attempt to send additional entries
   *          or references to the client if desired, or {@code false} if not
   *          (e.g., because the size limit or time limit has been exceeded, or
   *          because the connection has been closed).
   */
  boolean sendEntry(final SearchResultEntry entry,
                    final boolean applyTransformations);



  /**
   * Attempts to return the provided search result reference to the client.
   *
   * @param  reference             The reference to return to the client.
   * @param  applyTransformations  Indicates whether to apply any configured
   *                               proxy transformations to the reference before
   *                               returning it to the client.
   *
   * @return  {@code true} if the caller may attempt to send additional entries
   *          or references to the client if desired, or {@code false} if not
   *          (e.g., because the size limit or time limit has been exceeded, or
   *          because the connection has been closed).
   */
  boolean sendReference(final SearchResultReference reference,
                        final boolean applyTransformations);
}
