/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.proxy.types;



import java.util.List;

import com.unboundid.directory.sdk.common.types.OperationType;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This interface defines a set of methods that may be used to interact with a
 * set of backend servers to be accessed through an entry-balancing request
 * processor.  All the servers in the set will have an identical set of data
 * for the entry-balanced portion.
 */
@NotExtensible()
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public interface BackendSet
{
  /**
   * Retrieves a unique identifier for this backend set.
   *
   * @return  A unique identifier for this backend set.
   */
  String getBackendSetID();



  /**
   * Retrieves the DN of the configuration entry for the proxying request
   * processor that defines this backend set.
   *
   * @return  The DN of the configuration entry for the proxying request
   *          processor that defines this backend set.
   */
  String getConfigEntryDN();



  /**
   * Retrieves the list of servers associated with this backend set.
   *
   * @return  The list of servers associated with this backend set.
   */
  List<BackendServer> getBackendServers();



  /**
   * Retrieves a newly-established connection to one of the servers in this
   * backend set which is capable of processing all of the specified types of
   * operations.  The caller is responsible for closing the connection when it
   * is no longer needed.
   *
   * @param  options  The set of connection options to use for the connection.
   *                  It may be {@code null} if a default set of connection
   *                  options should be used.
   * @param  opTypes  The types of operations expected to be processed on the
   *                  connection that is created.  It must not be {@code null}
   *                  or empty.
   *
   * @return  The newly-created connection to one of the servers in this backend
   *          set.
   *
   * @throws  LDAPException  If a problem occurred while attempting to create
   *                         the connection, or if none of the backend servers
   *                         is available for the provided set of operation
   *                         types.
   */
  LDAPConnection getConnection(final LDAPConnectionOptions options,
                               final OperationType... opTypes)
                 throws LDAPException;
}
