/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2009-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.proxy.types;



/**
 * This enum defines the set of possible states that may be returned by LDAP
 * health checks.
 */
public enum HealthCheckState
{
  /**
   * The health check state that indicates that the associated server is fully
   * available for use.
   */
  AVAILABLE,



  /**
   * The health check state that indicates that the associated server is in a
   * degraded state and should be avoided if another server may be more
   * suitable.
   */
  DEGRADED,



  /**
   * The health check state that indicates that the associated server is not
   * available and must not be used.
   */
  UNAVAILABLE;
}
