/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.proxy.types;



import java.util.List;
import java.util.Map;

import com.unboundid.directory.sdk.common.types.ServerContext;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This interface may be used to obtain information about the Directory Proxy
 * Server in which an extension is running.
 */
@NotExtensible()
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public interface ProxyServerContext
       extends ServerContext
{
   /**
   * Creates a health check result with the provided information.
   *
   * @param  state     The health check state for the result.  It must not be
   *                   {@code null}.
   * @param  score     The score for the result.  It must be an integer value
   *                   between 1 and 10 for a state of AVAILABLE or DEGRADED, or
   *                   zero for a state of UNAVAILABLE.
   * @param  messages  A set of messages with additional information about the
   *                   reason for the provided state and score.  It may be
   *                   {@code null} or empty if no messages are needed.
   *
   * @return  The created health check result.
   */
  HealthCheckResult createHealthCheckResult(final HealthCheckState state,
                                            final int score,
                                            final String... messages);



  /**
   * Creates a health check result with the provided information.
   *
   * @param  state     The health check state for the result.  It must not be
   *                   {@code null}.
   * @param  score     The score for the result.  It must be an integer value
   *                   between 1 and 10 for a state of AVAILABLE or DEGRADED, or
   *                   zero for a state of UNAVAILABLE.
   * @param  messages  A set of messages with additional information about the
   *                   reason for the provided state and score.  It may be
   *                   {@code null} or empty if no messages are needed.
   *
   * @return  The created health check result.
   */
  HealthCheckResult createHealthCheckResult(final HealthCheckState state,
                                            final int score,
                                            final List<String> messages);



  /**
   * Aggregates the information contained in the provided list of health check
   * results into a single result.  The aggregate result will be the worst
   * result of all of the provided results, and will contain all the messages
   * from all of the given results.
   *
   * @param  results  The list of health check results to be aggregated.  It
   *                  must not be {@code null} or empty.
   *
   * @return  The health check result which is an aggregation of the provided
   *          list of results.
   */
  HealthCheckResult aggregate(final List<HealthCheckResult> results);



  /**
   * For each Subtree View, return the corresponding {@code RequestProcessor}
   * in a map keyed by the configured name of the Subtree View.
   * This is particularly useful for getting access to
   * {@code EntryBalancingRequestProcessors}
   * One use case of this method is to modify an incoming LDAP
   * request in a {@code Plugin#doPreParse} implementation by accessing the
   * Entry Balancing Request Processor's global indexes using the
   * {@code EntryBalancingRequestProcessor#getGlobalIndexHint} methods.
   *
   * @return  A map from the configured name of the Subtree View to its
   *          corresponding RequestProcessor.
   */
  Map<String,RequestProcessor> getRequestProcessors();
}
