/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.sync.config;



import java.util.Set;

import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This interface defines a set of methods that may be used to obtain
 * information about the general configuration for a JDBC Sync Source.
 */
@NotExtensible()
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public interface JDBCSyncSourceConfig
       extends GenericSyncConfig
{
  /**
   * Gets the description for this Sync Source.
   * @return the description, or null if there is none set.
   */
  String getDescription();

  /**
   * Gets the maximum number of connections that the Sync Source
   * is allowed to have open to the database at a given time.
   * @return an integer between 1 and 1000
   */
  int getMaxOpenConnections();

  /**
   * Gets the list of configured database entry types that are used
   * to uniquely identify a set of data in the database that makes up
   * an LDAP entry. Changes that do not match one of these entry types
   * are dropped by the sync source.
   * @return a set of database entry types
   */
  Set<String> getDatabaseEntryType();

  /**
   * Gets the configured users from which detected changes will be ignored.
   * <p>
   * This is particularly useful when using the ${SYNC_SERVER_BASE_NAME} to sync
   * changes back to this source (i.e. bi-directional sync).
   * In this case, a unique user account would be used by the Sync Pipe that
   * applies changes to this source, and that user would be in this list to
   * prevent those changes from being synchronized back to their original
   * source.
   * @return the set of database login names from which changes will be ignored
   */
  Set<String> getIgnoreChangesByUser();

  /**
   * Gets the configured amount of time (in milliseconds) after which changelog
   * entries should be deleted from the changelog or corresponding table in the
   * database.
   * @return a long value that is greater than or equal to 1
   */
  long getChangelogMaximumAge();
}
