/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.sync.types;

/**
 * This class contains the possible completion reasons for a synchronization
 * operation. This information is returned in a {@link DatabaseChangeRecord}
 * after it is acknowledged back to the sync source.
 */
public enum CompletionStatus
{
  /**
   * The operation completed successfully.
   */
  COMPLETED_SUCCESS,

  /**
   * The operation was dropped because it was out of scope (did not match any
   * sync classes).
   */
  COMPLETED_OUT_OF_SCOPE,

  /**
   * The change was dropped because the operation type (e.g. create) is not
   * synchronized.
   */
  COMPLETED_OP_TYPE_NOT_SYNCED,

  /**
   * No change was necessary because the destination entry was already in sync.
   */
  COMPLETED_NO_CHANGE_NEEDED,

  /**
   * The operation was aborted by a custom sync plugin.
   */
  COMPLETED_ABORTED_BY_PLUGIN,

  /**
   * The operation was unsuccessful because the entry already existed
   * at the destination (applies only to CREATE operations).
   */
  COMPLETED_ENTRY_ALREADY_EXISTS,

  /**
   * The operation was unsuccessful because no matching destination entry could
   * be found (applies only to MODIFY and DELETE operations).
   */
  COMPLETED_NO_MATCH_FOUND,

  /**
   * The operation was unsuccessful because multiple matches for a source entry
   * were found at the destination.
   */
  COMPLETED_MULTIPLE_MATCHES_FOUND,

  /**
   * The operation was unsuccessful because there was a failure during attribute
   * or DN mapping.
   */
  COMPLETED_FAILED_DURING_MAPPING,

  /**
   * The operation was unsuccessful because there was a failure at one of the
   * endpoint resources.
   */
  COMPLETED_FAILED_AT_RESOURCE,

  /**
   * The operation was unsuccessful because it there was a failure during
   * plugin processing.
   */
  COMPLETED_FAILED_IN_PLUGIN,

  /**
   * The operation was unsuccessful because there was an
   * unexpected exception during processing (e.g. a RunTimeException).
   */
  COMPLETED_FAILED_UNEXPECTED_EXCEPTION;
}
