/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.sync.types;

/**
 * This interface represents a single kafka message.
 */
public interface KafkaMessage {

  /**
   * Return the Kafka partition key.
   *
   * @return  The Kafka partition key.
   */
  String getKey();

  /**
   * Set the Kafka partition key.
   *
   * @param  key  The new Kafka partition key.
   */
  void setKey(final String key);

  /**
   * Return the value in the Kafka message. Unless changed by
   * another plugin, this value will be a valid JSON object
   * formatted as a string.
   *
   * @return The value in the Kafka message.
   */
  String getValue();

  /**
   * Set the value in the Kafka message. The value provided
   * need not be JSON.
   *
   * @param  value  The new value in the Kafka message.
   */
  void setValue(final String value);
}
