/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.sync.types;

/**
 * This result is returned by plugins that are invoked before a step of the
 * synchronization processing.  It directs the core synchronization processing
 * code how to continue processing the operation.
 */
public enum PreStepResult
{
  /**
   * This result indicates that processing should continue with the current
   * step.
   */
  CONTINUE,



  /**
   * This result indicates that processing should skip the current step
   * and then continue.  Plugins that return this result take on full
   * responsibility for providing the functionality of the skipped step.
   */
  SKIP_CURRENT_STEP,



  /**
   * This result indicates that the current operation should be aborted without
   * any additional processing.
   */
  ABORT_OPERATION,



  /**
   * This result indicates that there was some error processing the
   * current operation in the plugin and that it should be retried a limited
   * number of times.
   */
  RETRY_OPERATION_LIMITED,



  /**
   * This result indicates that there was some error processing the
   * current operation in the plugin and that it should be retried an limited
   * number of times. Be very careful returning this value as it can stall all
   * in-flight operations until the operation completes. This should only be
   * used in situations where a remote service (e.g. the LDAP server) is
   * unavailable.
   */
  RETRY_OPERATION_UNLIMITED;
}
