/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.sync.types;

/**
 * The type of a Sync Operation.
 */
public enum SyncOperationType
{
  /**
   * The Sync Operation Type that indicates that a new entry was created.
   */
  CREATE,



  /**
   * The Sync Operation Type that indicates that an entry was deleted.
   */
  DELETE,



  /**
   * The Sync Operation Type that indicates that an entry was modified or
   * renamed.
   */
  MODIFY,



  /**
   * The Sync Operation Type that indicates that an entry is being
   * resynchronized as part of a 'resync' operation.
   */
  RESYNC;
}
