/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.sync.types;



import com.unboundid.directory.sdk.common.types.ServerContext;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

import java.util.Collection;
import java.util.Set;


/**
 * This interface may be used to obtain information about the
 * ${SYNC_SERVER_BASE_NAME} in which an extension is running.
 */
@NotExtensible()
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public interface SyncServerContext
       extends ServerContext
{
  /**
   * Returns an entry that has had the DN and attributes mapped according to the
   * maps specified by dnMapNames and attributeMapNames.
   *
   * @param sourceEntry
   *          The source entry to map.
   *
   * @param dnMapNames
   *          The names of the DN maps in the configuration that should be
   *          applied. This list can be empty if no DN maps should be applied.
   *          Multiple DN maps can be specified if source DNs might match
   *          different DN patterns.  The most specific patterns should be
   *          specified first.
   *
   * @param attributeMapNames
   *          The names of the attribute maps in the configuration that should
   *          be applied. This list can be empty if no attribute mappings
   *          should be applied. This parameter works in conjunction with the
   *          autoMappedSrcAttributes and excludedAutoMapAttributes parameters.
   *
   * @param autoMappedSrcAttributes
   *          The set of source attribute names that should be automatically
   *          mapped to a destination attribute with the same name.   You can
   *          use the special values '-all-' to auto-map every Sync Source
   *          attribute, and '-none-' to not auto-map any Sync Source
   *          attributes.
   *
   * @param excludedAutoMapAttributes
   *          The set of source attribute names that should not be automatically
   *          mapped to a destination attribute with the same name.
   *
   * @param excludedAutoMapAttributeRegex
   *          A set of regular expressions that match source attribute names
   *          that should not be automatically mapped to a destination
   *          attribute with the same name.
   *
   * @return  An entry that has had the DN and attributes mapped according to
   *          the information given above.
   *
   * @throws LDAPException
   *          If the mapping fails.
   */
  Entry applyMaps(final Entry sourceEntry,
                  final Collection<String> dnMapNames,
                  final Collection<String> attributeMapNames,
                  final Set<String> autoMappedSrcAttributes,
                  final Set<String> excludedAutoMapAttributes,
                  final Set<String> excludedAutoMapAttributeRegex)
                  throws LDAPException;
}
