/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2018-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.sync.types;

/**
 * This interface provides basic contextual information about a
 * SyncSource and the SyncPipe that is actively using it. It is intended to
 * be extended for other Sync Sources so that additional context can be
 * provided.
 */
public interface SyncSourceContext {
  /**
   * Returns the active Sync Pipe.
   * @return The Sync Pipe.
   */
  String getSyncPipeName();

  /**
   * Returns the name of the Sync Source.
   * @return The name of the Sync Source.
   */
  String getName();
}
