/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.directory.sdk.broker.types;

import com.unboundid.util.NotExtensible;

@NotExtensible
public final class StatusResult {
    private final boolean ready;
    private final String error;
    private final String errorDetail;
    private final String responseParams;
    private final String diagnosticMessage;

    public static Builder ready() {
        Builder b = new Builder();
        b.ready = true;
        return b;
    }

    public static Builder notReady() {
        Builder b = new Builder();
        b.ready = false;
        return b;
    }

    public static Builder notReady(String error, String errorDetail) {
        Builder b = new Builder();
        b.ready = false;
        b.error = error;
        b.errorDetail = errorDetail;
        return b;
    }

    private StatusResult(boolean ready, String error, String errorDetail, String responseParams, String diagnosticMessage) {
        this.ready = ready;
        this.error = error;
        this.errorDetail = errorDetail;
        this.responseParams = responseParams;
        this.diagnosticMessage = diagnosticMessage;
    }

    public boolean isReady() {
        return this.ready;
    }

    public String getError() {
        return this.error;
    }

    public String getErrorDetail() {
        return this.errorDetail;
    }

    public String getResponseParams() {
        return this.responseParams;
    }

    public String getDiagnosticMessage() {
        return this.diagnosticMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusResult that = (StatusResult)o;
        if (this.ready != that.ready) {
            return false;
        }
        if (this.error != null ? !this.error.equals(that.error) : that.error != null) {
            return false;
        }
        if (this.errorDetail != null ? !this.errorDetail.equals(that.errorDetail) : that.errorDetail != null) {
            return false;
        }
        return this.responseParams != null ? !this.responseParams.equals(that.responseParams) : that.responseParams != null;
    }

    public int hashCode() {
        int result = this.ready ? 1 : 0;
        result = 31 * result + (this.error != null ? this.error.hashCode() : 0);
        result = 31 * result + (this.errorDetail != null ? this.errorDetail.hashCode() : 0);
        result = 31 * result + (this.responseParams != null ? this.responseParams.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StatusResult{");
        sb.append("ready=").append(this.ready);
        sb.append(", error='").append(this.error).append('\'');
        sb.append(", errorDetail='").append(this.errorDetail).append('\'');
        sb.append(", responseParams='").append(this.responseParams).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static class Builder {
        private boolean ready;
        private String error;
        private String errorDetail;
        private String responseParams;
        private String diagnosticMessage;

        public Builder setResponseParams(String responseParams) {
            this.responseParams = responseParams;
            return this;
        }

        public Builder setDiagnosticMessage(String diagnosticMessage) {
            this.diagnosticMessage = diagnosticMessage;
            return this;
        }

        public StatusResult build() {
            return new StatusResult(this.ready, this.error, this.errorDetail, this.responseParams, this.diagnosticMessage);
        }
    }
}

