/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.directory.sdk.broker.types;

import com.unboundid.util.NotExtensible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

@NotExtensible
public final class StoreAttributeDefinition {
    private final String name;
    private final Type type;
    private final String description;
    private final Collection<StoreAttributeDefinition> subAttributes;
    private final boolean multiValued;

    private StoreAttributeDefinition(String name, Type type, Collection<StoreAttributeDefinition> subAttributes, boolean multiValued, String description) {
        this.name = name;
        this.type = type;
        this.subAttributes = subAttributes == null ? null : Collections.unmodifiableList(new ArrayList<StoreAttributeDefinition>(subAttributes));
        this.multiValued = multiValued;
        this.description = description;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Collection<StoreAttributeDefinition> getSubAttributes() {
        return this.subAttributes;
    }

    public String toString() {
        return this.toIndentedString("");
    }

    private String toIndentedString(String indent) {
        StringBuilder builder = new StringBuilder();
        builder.append(indent);
        builder.append("Name: ");
        builder.append(this.getName());
        builder.append(" Description: ");
        builder.append(this.getDescription());
        builder.append(" isReadOnly: ");
        builder.append(System.lineSeparator());
        if (this.getSubAttributes() != null) {
            for (StoreAttributeDefinition a : this.getSubAttributes()) {
                builder.append(a.toIndentedString(indent + "  "));
            }
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreAttributeDefinition that = (StoreAttributeDefinition)o;
        if (this.multiValued != that.multiValued) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.subAttributes != null ? !this.subAttributes.equals(that.subAttributes) : that.subAttributes != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals((Object)that.type) : that.type != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.subAttributes != null ? this.subAttributes.hashCode() : 0);
        result = 31 * result + (this.multiValued ? 1 : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private String name;
        private Type type = Type.STRING;
        private Collection<StoreAttributeDefinition> subAttributes;
        private boolean multiValued;
        private String description;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        public Builder addSubAttributes(StoreAttributeDefinition ... subAttributes) {
            if (subAttributes != null && subAttributes.length > 0) {
                if (this.subAttributes == null) {
                    this.subAttributes = new LinkedList<StoreAttributeDefinition>();
                }
                this.subAttributes.addAll(Arrays.asList(subAttributes));
            }
            return this;
        }

        public Builder setMultiValued(boolean multiValued) {
            this.multiValued = multiValued;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder clear() {
            this.name = null;
            this.type = Type.STRING;
            this.subAttributes = null;
            this.multiValued = false;
            this.description = null;
            return this;
        }

        public StoreAttributeDefinition build() {
            return new StoreAttributeDefinition(this.name, this.type, this.subAttributes, this.multiValued, this.description);
        }
    }

    public static enum Type {
        STRING("string"),
        BOOLEAN("boolean"),
        DECIMAL("decimal"),
        INTEGER("integer"),
        DATETIME("datetime"),
        BINARY("binary"),
        REFERENCE("reference"),
        COMPLEX("complex");

        private String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Type fromName(String name) {
            for (Type type : Type.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            throw new RuntimeException("Unknown StoreAttributeDefinition datatype");
        }
    }
}

