/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.directory.sdk.common.api;

import com.unboundid.directory.sdk.broker.internal.BrokerExtension;
import com.unboundid.directory.sdk.common.config.VelocityContextProviderConfig;
import com.unboundid.directory.sdk.common.internal.ExampleUsageProvider;
import com.unboundid.directory.sdk.common.internal.Reconfigurable;
import com.unboundid.directory.sdk.common.internal.UnboundIDExtension;
import com.unboundid.directory.sdk.common.types.ServerContext;
import com.unboundid.directory.sdk.common.types.VelocityContext;
import com.unboundid.directory.sdk.ds.internal.DirectoryServerExtension;
import com.unboundid.directory.sdk.metrics.internal.MetricsEngineExtension;
import com.unboundid.directory.sdk.proxy.internal.DirectoryProxyServerExtension;
import com.unboundid.directory.sdk.sync.internal.SynchronizationServerExtension;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Extensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

@Extensible
@DirectoryServerExtension
@DirectoryProxyServerExtension(appliesToLocalContent=true, appliesToRemoteContent=false)
@SynchronizationServerExtension(appliesToLocalContent=true, appliesToSynchronizedContent=false)
@MetricsEngineExtension
@BrokerExtension
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class VelocityContextProvider
implements UnboundIDExtension,
Reconfigurable<VelocityContextProviderConfig>,
ExampleUsageProvider {
    private VelocityContextProviderConfig config;

    @Override
    public abstract String getExtensionName();

    @Override
    public abstract String[] getExtensionDescription();

    @Override
    public void defineConfigArguments(ArgumentParser parser) throws ArgumentException {
    }

    public void initializeVelocityContextProvider(ServerContext serverContext, VelocityContextProviderConfig config, ArgumentParser parser) throws LDAPException {
        this.config = config;
    }

    @Override
    public boolean isConfigurationAcceptable(VelocityContextProviderConfig config, ArgumentParser parser, List<String> unacceptableReasons) {
        return true;
    }

    @Override
    public ResultCode applyConfiguration(VelocityContextProviderConfig config, ArgumentParser parser, List<String> adminActionsRequired, List<String> messages) {
        if (!parser.getNamedArguments().isEmpty()) {
            adminActionsRequired.add("No configuration change has actually been applied.  The new configuration will not take effect until this Velocity context provider is disabled and re-enabled or until the server is restarted.");
        }
        return ResultCode.SUCCESS;
    }

    public void finalizeVelocityContextProvider() {
    }

    public void handleDelete(VelocityContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(405);
    }

    public void handleGet(VelocityContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
    }

    public void handleHead(VelocityContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(405);
    }

    public void handleOptions(VelocityContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(405);
    }

    public void handlePatch(VelocityContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(405);
    }

    public void handlePost(VelocityContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
    }

    public void handlePut(VelocityContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(405);
    }

    public void handleTrace(VelocityContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(405);
    }

    public void handleAdditionalMethod(VelocityContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(405);
    }

    public void updateContext(VelocityContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
    }

    protected <T> T getNamedObject(String name, HttpServletRequest request) {
        T object = null;
        if (this.config != null) {
            object = VelocityContextProvider.getNamedObject(name, request, this.config.getObjectScope());
        }
        return object;
    }

    protected void setNamedObject(String name, Object object, HttpServletRequest request) {
        if (this.config != null) {
            VelocityContextProvider.setNamedObject(name, object, request, this.config.getObjectScope());
        }
    }

    public static <T> T getNamedObject(String name, HttpServletRequest request, VelocityContextProviderConfig.ObjectScope scope) {
        Object object = null;
        Object o = null;
        if (name != null && request != null) {
            if (VelocityContextProviderConfig.ObjectScope.REQUEST.equals((Object)scope)) {
                o = request.getAttribute(name);
            } else if (VelocityContextProviderConfig.ObjectScope.SESSION.equals((Object)scope)) {
                HttpSession session = request.getSession(false);
                if (session != null) {
                    o = session.getAttribute(name);
                }
            } else if (VelocityContextProviderConfig.ObjectScope.APPLICATION.equals((Object)scope)) {
                o = request.getServletContext().getAttribute(name);
            }
        }
        try {
            object = o;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return (T)object;
    }

    public static void setNamedObject(String name, Object object, HttpServletRequest request, VelocityContextProviderConfig.ObjectScope scope) {
        if (scope != null && request != null && name != null) {
            if (VelocityContextProviderConfig.ObjectScope.REQUEST.equals((Object)scope)) {
                request.setAttribute(name, object);
            } else if (VelocityContextProviderConfig.ObjectScope.SESSION.equals((Object)scope)) {
                HttpSession session = request.getSession(true);
                session.setAttribute(name, object);
            } else if (VelocityContextProviderConfig.ObjectScope.APPLICATION.equals((Object)scope)) {
                request.getServletContext().setAttribute(name, object);
            }
        }
    }
}

