/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.directory.sdk.common.types;

import com.unboundid.directory.sdk.common.types.AuthInfo;
import com.unboundid.directory.sdk.common.types.DisconnectReason;
import com.unboundid.directory.sdk.common.types.Group;
import com.unboundid.directory.sdk.common.types.InternalConnection;
import com.unboundid.directory.sdk.common.types.OperationContext;
import com.unboundid.directory.sdk.common.types.ServerContext;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.Set;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public interface ClientContext {
    public long getConnectionID();

    public List<String> getMatchedConnectionCriteria();

    public boolean matchesConnectionCriteria(String var1);

    public boolean isInternal();

    public InternalConnection getInternalRootConnection(boolean var1);

    public InternalConnection getInternalUserConnection(boolean var1) throws LDAPException;

    public InternalConnection getInternalConnection(String var1, boolean var2) throws LDAPException;

    public boolean isSecure();

    public String getProtocol();

    public long getConnectTime();

    public InetAddress getClientInetAddress();

    public InetAddress getServerInetAddress();

    public boolean isAuthenticated();

    public AuthInfo getAuthInfo();

    public boolean isMemberOf(String var1, OperationContext var2) throws LDAPException;

    public Map<DN, Group> getGroups(OperationContext var1, boolean var2) throws LDAPException;

    public boolean hasPrivilege(String var1, OperationContext var2) throws LDAPException;

    public Set<String> getPrivilegeNames();

    public void sendUnsolicitedNotification(String var1, ResultCode var2, String var3);

    public void disconnect(DisconnectReason var1, boolean var2, String var3);

    public ServerContext getServerContext();

    public Object getSASLAuthStateInfo();

    public void setSASLAuthStateInfo(Object var1);

    public Object getAttachment(String var1);

    public Object setAttachment(String var1, Object var2);

    public String toString();
}

