/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.directory.sdk.common.types;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class ExtensionBundle {
    public static final String MANIFEST_ATTR_TITLE = "Implementation-Title";
    public static final String MANIFEST_ATTR_VERSION = "Implementation-Version";
    public static final String MANIFEST_ATTR_VENDOR = "Implementation-Vendor";
    public static final String MANIFEST_ATTR_VENDOR_ID = "Implementation-Vendor-Id";
    public static final String MANIFEST_ATTR_URL = "Implementation-URL";
    public static final String MANIFEST_ATTR_SUPPORT_CONTACT = "Extension-Support-Contact";
    public static final String MANIFEST_ATTR_SERVER_SDK_VERSION = "UnboundID-Server-SDK-Version";
    public static final String CONFIG_PATH_RELATIVE = "config";
    public static final String LIBRARIES_PATH_RELATIVE = "lib";
    public static final String DOCUMENTATION_PATH_RELATIVE = "docs";
    public static final String HISTORY_PATH_RELATIVE = "history";
    public static final String UPDATE_PATH = "update";
    public static final String UPDATE_LOG_NAME = "update.log";
    private static final FileFilter JAR_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            if (!pathname.isFile()) {
                return false;
            }
            String name = pathname.getName();
            return name.endsWith(".jar");
        }
    };
    private final File extensionBundleDir;
    private final File extensionJarFile;
    private final Manifest manifest;
    private final String vendorId;
    private final String title;
    private final String version;
    private final String bundleId;
    private final String sdkVersion;

    public ExtensionBundle(File extensionBundleDir) throws IOException, IllegalArgumentException {
        File jarFile = null;
        Manifest jarManifest = null;
        String extensionVendorId = null;
        String extensionTitle = null;
        String extensionVersion = null;
        String extensionSdkVersion = null;
        boolean isValid = false;
        File[] files = extensionBundleDir.listFiles(JAR_FILTER);
        if (files != null) {
            File[] fileArray = extensionBundleDir.listFiles(JAR_FILTER);
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File file;
                jarFile = file = fileArray[i];
                JarFile jar = new JarFile(file);
                jarManifest = jar.getManifest();
                extensionVendorId = jarManifest.getMainAttributes().getValue(MANIFEST_ATTR_VENDOR_ID);
                extensionTitle = jarManifest.getMainAttributes().getValue(MANIFEST_ATTR_TITLE);
                extensionVersion = jarManifest.getMainAttributes().getValue(MANIFEST_ATTR_VERSION);
                extensionSdkVersion = jarManifest.getMainAttributes().getValue(MANIFEST_ATTR_SERVER_SDK_VERSION);
                if (extensionVendorId == null || extensionVendorId.isEmpty() || extensionTitle == null || extensionTitle.isEmpty() || extensionVersion == null || extensionVersion.isEmpty() || extensionSdkVersion == null || extensionSdkVersion.isEmpty()) continue;
                isValid = true;
                break;
            }
        }
        if (!isValid) {
            throw new FileNotFoundException("Cannot find a valid extension jar in bundle");
        }
        ExtensionBundle.checkCompatibility(extensionSdkVersion);
        this.extensionBundleDir = extensionBundleDir;
        this.extensionJarFile = jarFile;
        this.manifest = jarManifest;
        this.vendorId = extensionVendorId;
        this.title = extensionTitle;
        this.version = extensionVersion;
        this.sdkVersion = extensionSdkVersion;
        this.bundleId = extensionVendorId + "." + extensionTitle;
    }

    public String getTitle() {
        return this.title;
    }

    public String getVendor() {
        return this.manifest.getMainAttributes().getValue(MANIFEST_ATTR_VENDOR);
    }

    public String getVendorId() {
        return this.vendorId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getServerSDKVersion() {
        return this.sdkVersion;
    }

    public String getUrl() {
        return this.manifest.getMainAttributes().getValue(MANIFEST_ATTR_URL);
    }

    public String getSupportContact() {
        return this.manifest.getMainAttributes().getValue(MANIFEST_ATTR_SUPPORT_CONTACT);
    }

    public String getBundleId() {
        return this.bundleId;
    }

    public File getExtensionBundleDir() {
        return this.extensionBundleDir;
    }

    public File getExtensionJarFile() {
        return this.extensionJarFile;
    }

    public File getConfigDir() {
        return new File(this.extensionBundleDir, CONFIG_PATH_RELATIVE);
    }

    public File getConfigUpdateDir() {
        return new File(this.getConfigDir(), UPDATE_PATH);
    }

    public File getLibrariesDir() {
        return new File(this.extensionBundleDir, LIBRARIES_PATH_RELATIVE);
    }

    public File getDocumentationDir() {
        return new File(this.extensionBundleDir, DOCUMENTATION_PATH_RELATIVE);
    }

    public File getHistoryDir() {
        return new File(this.extensionBundleDir, HISTORY_PATH_RELATIVE);
    }

    public static void checkCompatibility(String serverSDKVersionString) throws IllegalArgumentException {
        int jarSDKPatch;
        int jarSDKPoint;
        int jarSDKMinor;
        int jarSDKMajor;
        try {
            String[] versionComps = serverSDKVersionString.split("\\.");
            jarSDKMajor = Integer.parseInt(versionComps[0]);
            jarSDKMinor = Integer.parseInt(versionComps[1]);
            jarSDKPoint = Integer.parseInt(versionComps[2]);
            jarSDKPatch = Integer.parseInt(versionComps[3]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Value '" + serverSDKVersionString + "' for manifest attribute '" + MANIFEST_ATTR_SERVER_SDK_VERSION + "' is malformed", e);
        }
        boolean acceptable = true;
        if (jarSDKMajor > 7) {
            acceptable = false;
        } else if (jarSDKMajor == 7) {
            if (jarSDKMinor > 3) {
                acceptable = false;
            } else if (jarSDKMinor == 3) {
                if (jarSDKPoint > 0) {
                    acceptable = false;
                } else if (jarSDKPoint == 0) {
                    boolean bl = acceptable = jarSDKPatch <= 0;
                }
            }
        }
        if (!acceptable) {
            String maxSupportedVersion = "7.3.0.0";
            throw new IllegalArgumentException("Extensions built using UnboundID Server SDK version " + serverSDKVersionString + ", which is newer than the maximum server SDK version of " + "7.3.0.0");
        }
    }

    public boolean containsClass(Class clazz) {
        try {
            URL url = this.extensionJarFile.toURI().toURL();
            CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
            if (codeSource != null) {
                return codeSource.getLocation().sameFile(url);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

