/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.directory.sdk.common.types;

import com.unboundid.directory.sdk.common.api.DiskSpaceConsumer;
import com.unboundid.directory.sdk.common.api.MonitorProvider;
import com.unboundid.directory.sdk.common.api.ServerShutdownListener;
import com.unboundid.directory.sdk.common.api.ServerThread;
import com.unboundid.directory.sdk.common.config.GenericConfig;
import com.unboundid.directory.sdk.common.schema.Schema;
import com.unboundid.directory.sdk.common.types.AlertSeverity;
import com.unboundid.directory.sdk.common.types.DegradedAlertType;
import com.unboundid.directory.sdk.common.types.EncryptionSettingsDefinition;
import com.unboundid.directory.sdk.common.types.Group;
import com.unboundid.directory.sdk.common.types.InternalConnection;
import com.unboundid.directory.sdk.common.types.LogSeverity;
import com.unboundid.directory.sdk.common.types.RegisteredDiskSpaceConsumer;
import com.unboundid.directory.sdk.common.types.RegisteredMonitorProvider;
import com.unboundid.directory.sdk.common.types.RegisteredServerShutdownListener;
import com.unboundid.directory.sdk.common.types.ToolExecutor;
import com.unboundid.directory.sdk.common.types.UnavailableAlertType;
import com.unboundid.directory.sdk.common.types.ValueConstructor;
import com.unboundid.directory.sdk.ds.api.ChangeListener;
import com.unboundid.directory.sdk.ds.types.RegisteredChangeListener;
import com.unboundid.directory.sdk.proxy.types.Location;
import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public interface ServerContext {
    public String getShortVendorName();

    public String getFullVendorName();

    public String getCompactProductName();

    public String getPackageName();

    public String getFullProductName();

    public String getBasicProductName();

    public int getMajorVersionNumber();

    public int getMinorVersionNumber();

    public int getPointVersionNumber();

    public int getPatchVersionNumber();

    public String getVersionNumber();

    public String getFullVersion();

    public String getVersionQualifier();

    public String getSourceRevision();

    public boolean isStarting();

    public boolean isRunning();

    public boolean isShuttingDown();

    public long getStartTime();

    public String getStartupID();

    public UUID getStartupUUID();

    public String getInstanceName();

    public Location getLocation();

    public File getServerRoot();

    public ToolExecutor getToolExecutor();

    public boolean isDirectoryFunctionalityAvailable();

    public boolean isDirectoryProxyFunctionalityAvailable();

    public boolean isSyncFunctionalityAvailable();

    public InternalConnection getInternalRootConnection();

    public InternalConnection getInternalConnection(String var1) throws LDAPException;

    public LDAPInterface getClientRootConnection(boolean var1);

    public LDAPInterface getClientConnection(String var1, boolean var2) throws LDAPException;

    public Schema getSchema();

    public void registerSupportedControlOID(String var1);

    public void deregisterSupportedControlOID(String var1);

    public RegisteredChangeListener registerChangeListener(ChangeListener var1, Set<ChangeType> var2, List<String> var3, Filter var4) throws LDAPException;

    public void deregisterChangeListener(RegisteredChangeListener var1);

    public RegisteredDiskSpaceConsumer registerDiskSpaceConsumer(DiskSpaceConsumer var1);

    public void deregisterDiskSpaceConsumer(RegisteredDiskSpaceConsumer var1);

    public RegisteredServerShutdownListener registerShutdownListener(ServerShutdownListener var1);

    public void deregisterShutdownListener(RegisteredServerShutdownListener var1);

    public RegisteredMonitorProvider registerMonitorProvider(MonitorProvider var1, GenericConfig var2);

    public void deregisterMonitorProvider(RegisteredMonitorProvider var1);

    public void deregisterAllMonitorProviders();

    public Thread createThread(ServerThread var1, String var2);

    public void logMessage(LogSeverity var1, String var2);

    public void sendAlert(AlertSeverity var1, String var2);

    public void sendAlert(String var1, AlertSeverity var2, String var3, String var4) throws LDAPException;

    public DegradedAlertType sendDegradedAlertNotification(String var1, AlertSeverity var2, String var3, String var4) throws LDAPException;

    public UnavailableAlertType sendUnavailableAlertNotification(String var1, AlertSeverity var2, String var3, String var4) throws LDAPException;

    public boolean debugEnabled();

    public void debugCaught(Throwable var1);

    public void debugThrown(Throwable var1);

    public void debugError(String var1);

    public void debugWarning(String var1);

    public void debugInfo(String var1);

    public void debugVerbose(String var1);

    public LDAPConnection getLDAPExternalServerConnection(String var1, LDAPConnectionOptions var2) throws LDAPException;

    public LDAPConnectionPool getLDAPExternalServerConnectionPool(String var1, LDAPConnectionOptions var2, int var3, int var4, boolean var5) throws LDAPException;

    public String getObscuredValue(String var1) throws LDAPException;

    public ValueConstructor createValueConstructor(String var1) throws LDAPException;

    public Group getGroup(String var1) throws LDAPException;

    public Map<DN, Group> getGroupsForUser(String var1, boolean var2) throws LDAPException;

    public boolean hasPrivilege(String var1, String var2) throws LDAPException;

    public Set<String> getPrivilegeNames(String var1) throws LDAPException;

    public void reloadHTTPConnectionHandlerCertificates() throws LDAPException;

    public InputStream getPossiblyCompressedAndEncryptedInputStream(File var1) throws LDAPException, GeneralSecurityException, IOException;

    public InputStream getPossiblyCompressedAndEncryptedInputStream(InputStream var1) throws LDAPException, GeneralSecurityException, IOException;

    public OutputStream getEncryptedOutputStream(OutputStream var1, boolean var2) throws LDAPException, IOException, GeneralSecurityException;

    public OutputStream getEncryptedOutputStream(OutputStream var1, String var2, boolean var3) throws LDAPException, GeneralSecurityException, IOException;

    public EncryptionSettingsDefinition getPreferredEncryptionSettingsDefinition();

    public EncryptionSettingsDefinition getEncryptionSettingsDefinition(String var1);

    public List<EncryptionSettingsDefinition> getEncryptionSettingsDefinitions();
}

