/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.directory.sdk.common.types;

import com.unboundid.util.NotExtensible;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@NotExtensible
public final class TokenValidationResult {
    private final Boolean active;
    private final Set<String> scope;
    private final String clientId;
    private final String username;
    private final String tokenType;
    private final Long expirationTime;
    private final Long issuedAt;
    private final Long notUsedBefore;
    private final String tokenSubject;
    private final String tokenOwner;
    private final Set<String> audience;
    private final String tokenIdentifier;
    private final Map<String, Object> additionalProperties;

    private TokenValidationResult(Builder builder) {
        this.active = builder.active;
        this.scope = builder.scope;
        this.clientId = builder.clientId;
        this.username = builder.username;
        this.tokenType = builder.tokenType;
        this.expirationTime = builder.expirationTime;
        this.issuedAt = builder.issuedAt;
        this.notUsedBefore = builder.notUsedBefore;
        this.tokenSubject = builder.tokenSubject;
        this.tokenOwner = builder.tokenOwner;
        this.audience = builder.audience;
        this.tokenIdentifier = builder.tokenIdentifier;
        this.additionalProperties = builder.additionalProperties == null ? Collections.emptyMap() : builder.additionalProperties;
    }

    public Boolean getActive() {
        return this.active;
    }

    public Set<String> getScope() {
        return this.scope;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getUsername() {
        return this.username;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public Long getExpirationTime() {
        return this.expirationTime;
    }

    public Long getIssuedAt() {
        return this.issuedAt;
    }

    public Long getNotUsedBefore() {
        return this.notUsedBefore;
    }

    public String getTokenSubject() {
        return this.tokenSubject;
    }

    public String getTokenOwner() {
        return this.tokenOwner;
    }

    public Set<String> getAudience() {
        return this.audience;
    }

    public String getTokenIdentifier() {
        return this.tokenIdentifier;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public static class Builder {
        private Boolean active;
        private Set<String> scope;
        private String clientId;
        private String username;
        private String tokenType;
        private Long expirationTime;
        private Long issuedAt;
        private Long notUsedBefore;
        private String tokenSubject;
        private String tokenOwner;
        private Set<String> audience;
        private String tokenIdentifier;
        private Map<String, Object> additionalProperties;

        public Builder(boolean active) {
            this.active = active;
            this.setScope(Collections.emptySet());
        }

        public Builder setActive(boolean active) {
            this.active = active;
            return this;
        }

        public Builder setScope(Set<String> scope) {
            this.scope = scope == null ? Collections.emptySet() : scope;
            return this;
        }

        public Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setTokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public Builder setExpirationTime(long expirationTime, TimeUnit timeUnit) {
            this.expirationTime = timeUnit.toSeconds(expirationTime);
            return this;
        }

        public Builder setIssuedAt(long issuedAt, TimeUnit timeUnit) {
            this.issuedAt = timeUnit.toSeconds(issuedAt);
            return this;
        }

        public Builder setNotUsedBefore(long notUsedBefore, TimeUnit timeUnit) {
            this.notUsedBefore = timeUnit.toSeconds(notUsedBefore);
            return this;
        }

        public Builder setTokenSubject(String tokenSubject) {
            this.tokenSubject = tokenSubject;
            return this;
        }

        public Builder setTokenOwner(String tokenOwner) {
            this.tokenOwner = tokenOwner;
            return this;
        }

        public Builder setAudience(Set<String> audience) {
            this.audience = audience;
            return this;
        }

        public Builder setTokenIdentifier(String tokenIdentifier) {
            this.tokenIdentifier = tokenIdentifier;
            return this;
        }

        public Builder setAdditionalProperties(Map<String, Object> properties) {
            this.additionalProperties = properties;
            return this;
        }

        public TokenValidationResult build() {
            return new TokenValidationResult(this);
        }
    }
}

