/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.directory.sdk.ds.api;

import com.unboundid.directory.sdk.common.internal.ExampleUsageProvider;
import com.unboundid.directory.sdk.common.internal.Reconfigurable;
import com.unboundid.directory.sdk.common.internal.UnboundIDExtension;
import com.unboundid.directory.sdk.common.types.Entry;
import com.unboundid.directory.sdk.ds.config.PasswordStorageSchemeConfig;
import com.unboundid.directory.sdk.ds.internal.DirectoryServerExtension;
import com.unboundid.directory.sdk.ds.types.DirectoryServerContext;
import com.unboundid.directory.sdk.proxy.internal.DirectoryProxyServerExtension;
import com.unboundid.directory.sdk.sync.internal.SynchronizationServerExtension;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.ByteString;
import com.unboundid.util.Extensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Extensible
@DirectoryServerExtension
@DirectoryProxyServerExtension(appliesToLocalContent=true, appliesToRemoteContent=false)
@SynchronizationServerExtension(appliesToLocalContent=true, appliesToSynchronizedContent=false)
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class EnhancedPasswordStorageScheme
implements UnboundIDExtension,
Reconfigurable<PasswordStorageSchemeConfig>,
ExampleUsageProvider {
    @Override
    public abstract String getExtensionName();

    @Override
    public abstract String[] getExtensionDescription();

    @Override
    public void defineConfigArguments(ArgumentParser parser) throws ArgumentException {
    }

    public void initializePasswordStorageScheme(DirectoryServerContext serverContext, PasswordStorageSchemeConfig config, ArgumentParser parser) throws LDAPException {
    }

    @Override
    public boolean isConfigurationAcceptable(PasswordStorageSchemeConfig config, ArgumentParser parser, List<String> unacceptableReasons) {
        return true;
    }

    @Override
    public ResultCode applyConfiguration(PasswordStorageSchemeConfig config, ArgumentParser parser, List<String> adminActionsRequired, List<String> messages) {
        if (!parser.getNamedArguments().isEmpty()) {
            adminActionsRequired.add("No configuration change has actually been applied.  The new configuration will not take effect until this password storage scheme is disabled and re-enabled or until the server is restarted.");
        }
        return ResultCode.SUCCESS;
    }

    public void finalizePasswordStorageScheme() {
    }

    public abstract String getStorageSchemeName();

    public abstract boolean isReversible();

    public abstract boolean isSecure();

    public boolean requiresUserEntry() {
        return false;
    }

    public abstract ByteString encodePassword(ByteString var1, Entry var2, List<Modification> var3, boolean var4, boolean var5) throws LDAPException;

    public abstract boolean passwordMatches(ByteString var1, ByteString var2, Entry var3);

    public abstract ByteString getPlaintextValue(ByteString var1, Entry var2) throws LDAPException;

    public boolean supportsAuthPasswordSyntax() {
        return false;
    }

    public String getAuthPasswordSchemeName() {
        return this.getStorageSchemeName();
    }

    public ByteString encodeAuthPassword(ByteString plaintext, Entry userEntry, List<Modification> modifications, boolean deterministic) throws LDAPException {
        throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, "This password storage scheme does not support the use of the authentication password syntax.");
    }

    public boolean authPasswordMatches(ByteString plaintextPassword, String authInfo, String authValue, Entry userEntry) {
        return false;
    }

    public ByteString getAuthPasswordPlaintextValue(String authInfo, String authValue, Entry userEntry) throws LDAPException {
        throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, "This password storage scheme does not support the use of the authentication password syntax.");
    }

    @Override
    public Map<List<String>, String> getExamplesArgumentSets() {
        return Collections.emptyMap();
    }
}

