/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.directory.sdk.ds.api;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.directory.sdk.common.internal.ExampleUsageProvider;
import com.unboundid.directory.sdk.common.internal.Reconfigurable;
import com.unboundid.directory.sdk.common.internal.UnboundIDExtension;
import com.unboundid.directory.sdk.common.operation.AddRequest;
import com.unboundid.directory.sdk.common.operation.DeleteRequest;
import com.unboundid.directory.sdk.common.operation.ModifyDNRequest;
import com.unboundid.directory.sdk.common.operation.ModifyRequest;
import com.unboundid.directory.sdk.common.types.Entry;
import com.unboundid.directory.sdk.common.types.OperationContext;
import com.unboundid.directory.sdk.ds.config.NotificationManagerConfig;
import com.unboundid.directory.sdk.ds.internal.DirectoryServerExtension;
import com.unboundid.directory.sdk.ds.types.DirectoryServerContext;
import com.unboundid.directory.sdk.ds.types.Notification;
import com.unboundid.directory.sdk.ds.types.NotificationDeliveryResult;
import com.unboundid.directory.sdk.ds.types.NotificationProperties;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.NotificationDestinationDetails;
import com.unboundid.util.Extensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Extensible
@DirectoryServerExtension
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class NotificationManager
implements UnboundIDExtension,
Reconfigurable<NotificationManagerConfig>,
ExampleUsageProvider {
    @Override
    public abstract String getExtensionName();

    @Override
    public abstract String[] getExtensionDescription();

    @Override
    public void defineConfigArguments(ArgumentParser parser) throws ArgumentException {
    }

    public void initializeNotificationManager(DirectoryServerContext serverContext, NotificationManagerConfig config, ArgumentParser parser) throws LDAPException {
    }

    public abstract void initializeNotificationDestinations(List<NotificationDestinationDetails> var1) throws LDAPException;

    public abstract boolean areDestinationDetailsAcceptable(String var1, List<ASN1OctetString> var2, List<String> var3);

    public abstract void setNotificationDestination(String var1, List<ASN1OctetString> var2) throws LDAPException;

    public abstract boolean areSubscriptionDetailsAcceptable(String var1, String var2, List<ASN1OctetString> var3, List<String> var4);

    public abstract void setNotificationSubscription(String var1, String var2, List<ASN1OctetString> var3) throws LDAPException;

    public abstract void deleteNotificationDestination(String var1);

    public abstract void deleteNotificationSubscription(String var1, String var2);

    public abstract boolean isPreferredForDestination(String var1);

    @Deprecated
    public List<NotificationProperties> getAddNotificationProperties(AddRequest addRequest) {
        throw new UnsupportedOperationException("One of the getAddNotificationProperties() methods must be implemented");
    }

    public List<NotificationProperties> getAddNotificationProperties(AddRequest addRequest, Entry addedEntry, OperationContext opContext) {
        return this.getAddNotificationProperties(addRequest);
    }

    @Deprecated
    public List<NotificationProperties> getDeleteNotificationProperties(DeleteRequest deleteRequest) {
        throw new UnsupportedOperationException("One of the getDeleteNotificationProperties() methods must be implemented");
    }

    public List<NotificationProperties> getDeleteNotificationProperties(DeleteRequest deleteRequest, Entry deletedEntry, OperationContext opContext) {
        return this.getDeleteNotificationProperties(deleteRequest);
    }

    @Deprecated
    public List<NotificationProperties> getModifyNotificationProperties(ModifyRequest modifyRequest) {
        throw new UnsupportedOperationException("One of the getModifyNotificationProperties() methods must be implemented");
    }

    public List<NotificationProperties> getModifyNotificationProperties(ModifyRequest modifyRequest, Entry oldEntry, Entry newEntry, OperationContext opContext) {
        return this.getModifyNotificationProperties(modifyRequest);
    }

    @Deprecated
    public List<NotificationProperties> getModifyDNNotificationProperties(ModifyDNRequest modifyDNRequest) {
        throw new UnsupportedOperationException("One of the getModifyDNNotificationProperties() methods must be implemented");
    }

    public List<NotificationProperties> getModifyDNNotificationProperties(ModifyDNRequest modifyDNRequest, Entry oldEntry, Entry newEntry, OperationContext opContext) {
        return this.getModifyDNNotificationProperties(modifyDNRequest);
    }

    public abstract NotificationDeliveryResult attemptDelivery(Notification var1);

    @Override
    public boolean isConfigurationAcceptable(NotificationManagerConfig config, ArgumentParser parser, List<String> unacceptableReasons) {
        return true;
    }

    @Override
    public ResultCode applyConfiguration(NotificationManagerConfig config, ArgumentParser parser, List<String> adminActionsRequired, List<String> messages) {
        if (!parser.getNamedArguments().isEmpty()) {
            adminActionsRequired.add("No configuration change has actually been applied.  The new configuration will not take effect until this notification manager is disabled and re-enabled or until the server is restarted.");
        }
        return ResultCode.SUCCESS;
    }

    public void finalizeNotificationManager() {
    }

    @Override
    public Map<List<String>, String> getExamplesArgumentSets() {
        return Collections.emptyMap();
    }
}

