/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.directory.sdk.ds.api;

import com.unboundid.directory.sdk.common.internal.ExampleUsageProvider;
import com.unboundid.directory.sdk.common.internal.Reconfigurable;
import com.unboundid.directory.sdk.common.internal.UnboundIDExtension;
import com.unboundid.directory.sdk.common.types.Entry;
import com.unboundid.directory.sdk.ds.config.OneTimePasswordDeliveryMechanismConfig;
import com.unboundid.directory.sdk.ds.internal.DirectoryServerExtension;
import com.unboundid.directory.sdk.ds.types.DirectoryServerContext;
import com.unboundid.directory.sdk.proxy.internal.DirectoryProxyServerExtension;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.SupportedOTPDeliveryMechanismInfo;
import com.unboundid.util.Extensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Extensible
@DirectoryServerExtension
@DirectoryProxyServerExtension(appliesToLocalContent=true, appliesToRemoteContent=true)
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class OneTimePasswordDeliveryMechanism
implements UnboundIDExtension,
Reconfigurable<OneTimePasswordDeliveryMechanismConfig>,
ExampleUsageProvider {
    @Override
    public abstract String getExtensionName();

    @Override
    public abstract String[] getExtensionDescription();

    @Override
    public void defineConfigArguments(ArgumentParser parser) throws ArgumentException {
    }

    public void initializeOTPDeliveryMechanism(DirectoryServerContext serverContext, OneTimePasswordDeliveryMechanismConfig config, ArgumentParser parser) throws LDAPException {
    }

    @Override
    public boolean isConfigurationAcceptable(OneTimePasswordDeliveryMechanismConfig config, ArgumentParser parser, List<String> unacceptableReasons) {
        return true;
    }

    @Override
    public ResultCode applyConfiguration(OneTimePasswordDeliveryMechanismConfig config, ArgumentParser parser, List<String> adminActionsRequired, List<String> messages) {
        if (!parser.getNamedArguments().isEmpty()) {
            adminActionsRequired.add("No configuration change has actually been applied.  The new configuration will not take effect until this one-time password delivery mechanism is disabled and re-enabled or until the server is restarted.");
        }
        return ResultCode.SUCCESS;
    }

    public void finalizeOTPDeliveryMechanism() {
    }

    public abstract String deliverOneTimePassword(String var1, Entry var2, String var3, StringBuilder var4) throws LDAPException;

    public boolean supportsGenericMessageDelivery() {
        return false;
    }

    public String deliverMessage(OneTimePasswordDeliveryMechanismConfig config, String tokenID, String tokenValue, String messageSubject, String fullMessage, String compactMessage, Entry userEntry, String targetRecipientID, StringBuilder resultMessage) throws LDAPException {
        throw new LDAPException(ResultCode.OTHER, "The '" + config.getConfigObjectName() + "' OTP delivery mechanism does not support arbitrary message delivery.");
    }

    public void getSupportedDeliveryMechanismInfo(OneTimePasswordDeliveryMechanismConfig config, Entry userEntry, List<SupportedOTPDeliveryMechanismInfo> deliveryMechanismInfo) {
        deliveryMechanismInfo.add(new SupportedOTPDeliveryMechanismInfo(config.getConfigObjectName(), null, null));
    }

    @Override
    public Map<List<String>, String> getExamplesArgumentSets() {
        return Collections.emptyMap();
    }
}

