/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.directory.sdk.ds.api;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.directory.sdk.common.internal.ExampleUsageProvider;
import com.unboundid.directory.sdk.common.internal.Reconfigurable;
import com.unboundid.directory.sdk.common.internal.UnboundIDExtension;
import com.unboundid.directory.sdk.ds.config.PasswordStorageSchemeConfig;
import com.unboundid.directory.sdk.ds.internal.DirectoryServerExtension;
import com.unboundid.directory.sdk.ds.types.DirectoryServerContext;
import com.unboundid.directory.sdk.proxy.internal.DirectoryProxyServerExtension;
import com.unboundid.directory.sdk.sync.internal.SynchronizationServerExtension;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.ByteString;
import com.unboundid.util.Extensible;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Extensible
@DirectoryServerExtension
@DirectoryProxyServerExtension(appliesToLocalContent=true, appliesToRemoteContent=false)
@SynchronizationServerExtension(appliesToLocalContent=true, appliesToSynchronizedContent=false)
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class PasswordStorageScheme
implements UnboundIDExtension,
Reconfigurable<PasswordStorageSchemeConfig>,
ExampleUsageProvider {
    @Override
    public abstract String getExtensionName();

    @Override
    public abstract String[] getExtensionDescription();

    @Override
    public void defineConfigArguments(ArgumentParser parser) throws ArgumentException {
    }

    public void initializePasswordStorageScheme(DirectoryServerContext serverContext, PasswordStorageSchemeConfig config, ArgumentParser parser) throws LDAPException {
    }

    @Override
    public boolean isConfigurationAcceptable(PasswordStorageSchemeConfig config, ArgumentParser parser, List<String> unacceptableReasons) {
        return true;
    }

    @Override
    public ResultCode applyConfiguration(PasswordStorageSchemeConfig config, ArgumentParser parser, List<String> adminActionsRequired, List<String> messages) {
        if (!parser.getNamedArguments().isEmpty()) {
            adminActionsRequired.add("No configuration change has actually been applied.  The new configuration will not take effect until this password storage scheme is disabled and re-enabled or until the server is restarted.");
        }
        return ResultCode.SUCCESS;
    }

    public void finalizePasswordStorageScheme() {
    }

    public abstract String getStorageSchemeName();

    public abstract boolean isReversible();

    public abstract boolean isSecure();

    public abstract ByteString encodePassword(ByteString var1) throws LDAPException;

    public ByteString encodePasswordWithScheme(ByteString plaintext) throws LDAPException {
        byte[] schemeBytes = StaticUtils.getBytes((String)this.getStorageSchemeName());
        byte[] encodedPW = this.encodePassword(plaintext).getValue();
        byte[] b = new byte[schemeBytes.length + encodedPW.length + 2];
        int pos = 0;
        b[pos++] = 123;
        System.arraycopy(schemeBytes, 0, b, pos, schemeBytes.length);
        pos += schemeBytes.length;
        b[pos++] = 125;
        System.arraycopy(encodedPW, 0, b, pos, encodedPW.length);
        return new ASN1OctetString(b);
    }

    public ByteString encodePasswordWithScheme(ByteString plaintext, DN entryDN) throws LDAPException {
        return this.encodePasswordWithScheme(plaintext);
    }

    public abstract boolean passwordMatches(ByteString var1, ByteString var2);

    public abstract ByteString getPlaintextValue(ByteString var1) throws LDAPException;

    public boolean supportsAuthPasswordSyntax() {
        return false;
    }

    public String getAuthPasswordSchemeName() {
        return this.getStorageSchemeName();
    }

    public ByteString encodeAuthPassword(ByteString plaintext) throws LDAPException {
        throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, "This password storage scheme does not support the use of the authentication password syntax.");
    }

    public boolean authPasswordMatches(ByteString plaintext, String authInfo, String authValue) {
        return false;
    }

    public ByteString getAuthPasswordPlaintextValue(String authInfo, String authValue) throws LDAPException {
        throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, "This password storage scheme does not support the use of the authentication password syntax.");
    }

    @Override
    public Map<List<String>, String> getExamplesArgumentSets() {
        return Collections.emptyMap();
    }
}

