/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.directory.sdk.ds.api;

import com.unboundid.directory.sdk.common.internal.ExampleUsageProvider;
import com.unboundid.directory.sdk.common.internal.Reconfigurable;
import com.unboundid.directory.sdk.common.internal.UnboundIDExtension;
import com.unboundid.directory.sdk.common.operation.SASLBindRequest;
import com.unboundid.directory.sdk.common.types.Entry;
import com.unboundid.directory.sdk.common.types.OperationContext;
import com.unboundid.directory.sdk.ds.config.SASLMechanismHandlerConfig;
import com.unboundid.directory.sdk.ds.internal.DirectoryServerExtension;
import com.unboundid.directory.sdk.ds.types.DirectoryServerContext;
import com.unboundid.directory.sdk.ds.types.SASLBindResult;
import com.unboundid.directory.sdk.ds.types.SASLBindResultFactory;
import com.unboundid.directory.sdk.proxy.internal.DirectoryProxyServerExtension;
import com.unboundid.directory.sdk.sync.internal.SynchronizationServerExtension;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Extensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Extensible
@DirectoryServerExtension
@DirectoryProxyServerExtension(appliesToLocalContent=true, appliesToRemoteContent=true, notes="Any SASL bind requests received by the Directory Proxy Server will be processed by the Directory Proxy Server itself rather than being forwarded to backend servers.  However, a SASL mechanism handler running in the Directory Proxy Server may perform internal operations which reference content in the backend servers as if it was contained locally in the server.")
@SynchronizationServerExtension(appliesToLocalContent=true, appliesToSynchronizedContent=false)
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class SASLMechanismHandler
implements UnboundIDExtension,
Reconfigurable<SASLMechanismHandlerConfig>,
ExampleUsageProvider {
    @Override
    public abstract String getExtensionName();

    @Override
    public abstract String[] getExtensionDescription();

    @Override
    public void defineConfigArguments(ArgumentParser parser) throws ArgumentException {
    }

    public void initializeSASLMechanismHandler(DirectoryServerContext serverContext, SASLMechanismHandlerConfig config, ArgumentParser parser) throws LDAPException {
    }

    @Override
    public boolean isConfigurationAcceptable(SASLMechanismHandlerConfig config, ArgumentParser parser, List<String> unacceptableReasons) {
        return true;
    }

    @Override
    public ResultCode applyConfiguration(SASLMechanismHandlerConfig config, ArgumentParser parser, List<String> adminActionsRequired, List<String> messages) {
        if (!parser.getNamedArguments().isEmpty()) {
            adminActionsRequired.add("No configuration change has actually been applied.  The new configuration will not take effect until this SASL mechanism handler is disabled and re-enabled or until the server is restarted.");
        }
        return ResultCode.SUCCESS;
    }

    public void finalizeSASLMechanismHandler() {
    }

    public abstract List<String> getSASLMechanismNames();

    public abstract boolean isSecure(String var1);

    public abstract boolean isPasswordBased(String var1);

    public abstract SASLBindResult processSASLBind(OperationContext var1, SASLBindRequest var2, SASLBindResultFactory var3);

    @Override
    public Map<List<String>, String> getExamplesArgumentSets() {
        return Collections.emptyMap();
    }

    public Boolean isMechanismAvailableForUser(String mechanism, String passwordAttribute, Entry userEntry) {
        return null;
    }

    public Boolean isMultiStageMechanism(String mechanism) {
        return null;
    }
}

