/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.directory.sdk.ds.types;

import com.unboundid.directory.sdk.common.schema.AttributeType;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class NotificationProperties {
    private final String destinationID;
    private final Map<String, String> propertyMap;
    private final Set<AttributeType> keyAttributes;

    public NotificationProperties(String destinationID, Map<String, String> propertyMap, Set<AttributeType> keyAttributes) {
        this.destinationID = destinationID;
        this.propertyMap = propertyMap == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, String>(propertyMap));
        this.keyAttributes = keyAttributes == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<AttributeType>(keyAttributes));
    }

    public String getDestinationID() {
        return this.destinationID;
    }

    public Map<String, String> getPropertyMap() {
        return this.propertyMap;
    }

    public Set<AttributeType> getKeyAttributes() {
        return this.keyAttributes;
    }
}

