/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.directory.sdk.http.api;

import com.unboundid.directory.sdk.common.internal.ExampleUsageProvider;
import com.unboundid.directory.sdk.common.internal.Reconfigurable;
import com.unboundid.directory.sdk.common.internal.UnboundIDExtension;
import com.unboundid.directory.sdk.ds.internal.DirectoryServerExtension;
import com.unboundid.directory.sdk.http.config.OAuthTokenHandlerConfig;
import com.unboundid.directory.sdk.http.types.HTTPServerContext;
import com.unboundid.directory.sdk.proxy.internal.DirectoryProxyServerExtension;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.scim.sdk.OAuthToken;
import com.unboundid.scim.sdk.OAuthTokenStatus;
import com.unboundid.scim.sdk.SCIMRequest;
import com.unboundid.util.Extensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Extensible
@DirectoryServerExtension
@DirectoryProxyServerExtension(appliesToLocalContent=false, appliesToRemoteContent=true)
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class OAuthTokenHandler
implements UnboundIDExtension,
Reconfigurable<OAuthTokenHandlerConfig>,
ExampleUsageProvider {
    @Override
    public abstract String getExtensionName();

    @Override
    public abstract String[] getExtensionDescription();

    @Override
    public void defineConfigArguments(ArgumentParser parser) throws ArgumentException {
    }

    public void initializeTokenHandler(HTTPServerContext serverContext, OAuthTokenHandlerConfig config, ArgumentParser parser) throws LDAPException {
    }

    @Override
    public boolean isConfigurationAcceptable(OAuthTokenHandlerConfig config, ArgumentParser parser, List<String> unacceptableReasons) {
        return true;
    }

    @Override
    public ResultCode applyConfiguration(OAuthTokenHandlerConfig config, ArgumentParser parser, List<String> adminActionsRequired, List<String> messages) {
        if (!parser.getNamedArguments().isEmpty()) {
            adminActionsRequired.add("No configuration change has actually been applied. The new configuration will not take effect until the HTTP Connection Handler is disabled and re-enabled or until the server is restarted.");
        }
        return ResultCode.SUCCESS;
    }

    public void finalizeTokenHandler() {
    }

    @Override
    public Map<List<String>, String> getExamplesArgumentSets() {
        return Collections.emptyMap();
    }

    public abstract OAuthToken decodeOAuthToken(String var1) throws GeneralSecurityException;

    public abstract boolean isTokenExpired(OAuthToken var1) throws GeneralSecurityException;

    public abstract boolean isTokenAuthentic(OAuthToken var1) throws GeneralSecurityException;

    public abstract boolean isTokenForThisServer(OAuthToken var1) throws GeneralSecurityException;

    public abstract OAuthTokenStatus validateToken(OAuthToken var1, SCIMRequest var2) throws GeneralSecurityException;

    public abstract DN getAuthzDN(OAuthToken var1) throws GeneralSecurityException;
}

