/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.directory.sdk.proxy.types;

import com.unboundid.directory.sdk.common.types.OperationType;
import com.unboundid.directory.sdk.proxy.types.HealthCheckResult;
import com.unboundid.directory.sdk.proxy.types.Location;
import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.CompareRequest;
import com.unboundid.ldap.sdk.CompareResult;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ModifyDNRequest;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public interface BackendServer {
    public String getConfigEntryDN();

    public DN getParsedConfigEntryDN();

    public LDAPConnection createNewConnection(LDAPConnectionOptions var1, String var2) throws LDAPException;

    public Location getLocation();

    public String getServerAddress();

    public int getServerPort();

    public boolean isLocal();

    public int getActiveOperations();

    public HealthCheckResult getHealthCheckResult();

    public boolean isAvailable();

    public boolean supportsOperation(OperationType var1);

    public LDAPResult addUnaltered(AddRequest var1) throws LDAPException;

    public CompareResult compareUnaltered(CompareRequest var1) throws LDAPException;

    public LDAPResult deleteUnaltered(DeleteRequest var1) throws LDAPException;

    public LDAPResult modifyUnaltered(ModifyRequest var1) throws LDAPException;

    public LDAPResult modifyDNUnaltered(ModifyDNRequest var1) throws LDAPException;

    public SearchResult searchUnaltered(SearchRequest var1) throws LDAPException;
}

