/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.directory.sdk.proxy.types;

import com.unboundid.directory.sdk.proxy.types.BackendServer;
import com.unboundid.util.StaticUtils;
import java.util.Date;

public final class ServerAffinity {
    private final BackendServer backendServer;
    private final long affinityEstablishedTime;

    public ServerAffinity(BackendServer backendServer) {
        this.backendServer = backendServer;
        this.affinityEstablishedTime = System.currentTimeMillis();
    }

    public BackendServer getBackendServer() {
        return this.backendServer;
    }

    public long getAffinityEstablishedTime() {
        return this.affinityEstablishedTime;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ServerAffinity(backendServer='");
        buffer.append(this.backendServer.getServerAddress());
        buffer.append(':');
        buffer.append(this.backendServer.getServerPort());
        buffer.append("', establishedTime='");
        buffer.append(StaticUtils.encodeGeneralizedTime((Date)new Date(this.affinityEstablishedTime)));
        buffer.append("')");
    }
}

