/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.directory.sdk.sync.types;

import com.unboundid.directory.sdk.sync.types.CompletionStatus;
import com.unboundid.directory.sdk.sync.util.ScriptUtils;
import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ChangeRecord {
    private final long changeNumber;
    private final ChangeType changeType;
    private final DN identifiableInfo;
    private final DN identifiableInfoAfterChange;
    private final String[] changedAttributes;
    private final String modifier;
    private final long changeTime;
    private final Entry fullEntry;
    private final Map<Object, Object> properties;
    private CompletionStatus completionStatus;
    private static final AtomicLong uniqueIdSequence = new AtomicLong(0L);

    private ChangeRecord(Builder bldr) {
        this.changeNumber = bldr.changeNumber == -1L ? uniqueIdSequence.getAndIncrement() : bldr.changeNumber;
        this.changeType = bldr.changeType;
        this.identifiableInfo = bldr.identifiableInfo;
        this.identifiableInfoAfterChange = bldr.changeType == ChangeType.MODIFY_DN ? bldr.identifiableInfoAfterChange : this.identifiableInfo;
        this.changedAttributes = bldr.changedAttributes;
        this.modifier = bldr.modifier;
        this.changeTime = bldr.changeTime;
        this.fullEntry = bldr.fullEntry;
        this.properties = bldr.properties;
    }

    public long getChangeNumber() {
        return this.changeNumber;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public DN getIdentifiableInfo() {
        return this.identifiableInfo;
    }

    public DN getIdentifiableInfoAfterChange() {
        return this.identifiableInfoAfterChange;
    }

    public String[] getChangedAttributes() {
        return this.changedAttributes;
    }

    public String getModifier() {
        return this.modifier;
    }

    public long getChangeTime() {
        return this.changeTime;
    }

    public Entry getFullEntry() {
        return this.fullEntry;
    }

    public Object getProperty(Object key) {
        if (key == null) {
            return null;
        }
        return this.properties.get(key);
    }

    @InternalUseOnly
    public void setCompletionStatus(CompletionStatus status) {
        this.completionStatus = status;
    }

    public CompletionStatus getCompletionStatus() {
        return this.completionStatus;
    }

    public String toString() {
        String changeTypeStr = this.changeType != null ? this.changeType.toString() : "resync";
        String fullEntryStr = this.fullEntry != null ? ", fullEntry=" + this.fullEntry.toLDIFString() : "";
        return "ChangeRecord [changeNumber=" + this.changeNumber + ", changeType=" + changeTypeStr + ", identifiableInfo=" + this.identifiableInfo + ", identifiableInfoAfterChange=" + this.identifiableInfoAfterChange + ", changedAttributes=" + Arrays.toString(this.changedAttributes) + ", modifier=" + this.modifier + ", changeTime=" + new Date(this.changeTime).toString() + ", properties=" + this.properties + fullEntryStr + "]";
    }

    public static class Builder {
        private final ChangeType changeType;
        private final DN identifiableInfo;
        private long changeNumber;
        private String[] changedAttributes;
        private String modifier;
        private long changeTime;
        private Entry fullEntry;
        private DN identifiableInfoAfterChange;
        private final Map<Object, Object> properties = new ConcurrentHashMap<Object, Object>();
        private volatile boolean built;

        public Builder(ChangeType type, DN identifiableInfo) {
            if (identifiableInfo == null) {
                throw new IllegalArgumentException("The 'identifiableInfo' parameter cannot be null.");
            }
            this.changeType = type;
            this.identifiableInfo = identifiableInfo;
            this.changeNumber = -1L;
            this.built = false;
        }

        public Builder(ChangeType type, String identifiableInfo) {
            this(type, ScriptUtils.idStringToDN(identifiableInfo, null));
        }

        public Builder(ChangeType type, String identifiableInfo, String delimiter) {
            this(type, ScriptUtils.idStringToDN(identifiableInfo, delimiter));
        }

        public Builder changeNumber(long changeNumber) {
            this.changeNumber = changeNumber;
            return this;
        }

        public Builder identifiableInfoAfterChange(DN identifiableInfoAfterChange) {
            if (this.changeType != ChangeType.MODIFY_DN) {
                throw new IllegalArgumentException("identifiableInfoAfterChange can only be set for Modify DN changes.");
            }
            this.identifiableInfoAfterChange = identifiableInfoAfterChange;
            return this;
        }

        public Builder changedAttributes(String[] changedAttributes) {
            this.changedAttributes = changedAttributes;
            return this;
        }

        public Builder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        public Builder changeTime(long changeTime) {
            this.changeTime = changeTime;
            return this;
        }

        public Builder fullEntry(Entry entry) {
            this.fullEntry = entry;
            return this;
        }

        public Builder addProperty(Object key, Object value) {
            this.properties.put(key, value);
            return this;
        }

        public synchronized ChangeRecord build() {
            if (this.built) {
                throw new IllegalStateException("This Builder has already been built.");
            }
            this.built = true;
            return new ChangeRecord(this);
        }
    }
}

