/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.directory.sdk.sync.types;

import com.unboundid.directory.sdk.sync.types.CompletionStatus;
import com.unboundid.directory.sdk.sync.util.ScriptUtils;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DatabaseChangeRecord {
    private final long changeNumber;
    private final ChangeType changeType;
    private final String tableName;
    private final DN identifiableInfo;
    private final String entryType;
    private final String[] changedColumns;
    private final String modifier;
    private final long changeTime;
    private final Map<Object, Object> properties;
    private CompletionStatus completionStatus;
    private static final AtomicLong uniqueIdSequence = new AtomicLong(0L);

    private DatabaseChangeRecord(Builder bldr) {
        this.changeNumber = bldr.changeNumber == -1L ? uniqueIdSequence.getAndIncrement() : bldr.changeNumber;
        this.changeType = bldr.changeType;
        this.identifiableInfo = bldr.identifiableInfo;
        this.tableName = bldr.tableName;
        this.entryType = bldr.entryType;
        this.changedColumns = bldr.changedColumns;
        this.modifier = bldr.modifier;
        this.changeTime = bldr.changeTime;
        this.properties = bldr.properties;
    }

    public long getChangeNumber() {
        return this.changeNumber;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public DN getIdentifiableInfo() {
        return this.identifiableInfo;
    }

    public String getEntryType() {
        return this.entryType;
    }

    public String[] getChangedColumns() {
        return this.changedColumns;
    }

    public String getModifier() {
        return this.modifier;
    }

    public long getChangeTime() {
        return this.changeTime;
    }

    public Object getProperty(Object key) {
        if (key == null) {
            return null;
        }
        return this.properties.get(key);
    }

    @InternalUseOnly
    public void setCompletionStatus(CompletionStatus status) {
        this.completionStatus = status;
    }

    public CompletionStatus getCompletionStatus() {
        return this.completionStatus;
    }

    public String toString() {
        return "DatabaseChangeRecord [changeNumber=" + this.changeNumber + ", changeType=" + (Object)((Object)this.changeType) + ", tableName=" + this.tableName + ", identifiableInfo=" + this.identifiableInfo + ", entryType=" + this.entryType + ", changedColumns=" + Arrays.toString(this.changedColumns) + ", modifier=" + this.modifier + ", changeTime=" + new Date(this.changeTime).toString() + ", properties=" + this.properties + "]";
    }

    public static class Builder {
        private final ChangeType changeType;
        private final DN identifiableInfo;
        private long changeNumber;
        private String tableName;
        private String entryType;
        private String[] changedColumns;
        private String modifier;
        private long changeTime;
        private final Map<Object, Object> properties = new ConcurrentHashMap<Object, Object>();
        private volatile boolean built;

        public Builder(ChangeType type, DN identifiableInfo) {
            if (type == null || identifiableInfo == null) {
                throw new IllegalArgumentException("The 'type' and 'identifiableInfo' parameters can not be null.");
            }
            this.changeType = type;
            this.identifiableInfo = identifiableInfo;
            this.changeNumber = -1L;
            this.built = false;
        }

        public Builder(ChangeType type, String identifiableInfo) {
            this(type, ScriptUtils.idStringToDN(identifiableInfo, null));
        }

        public Builder(ChangeType type, String identifiableInfo, String delimiter) {
            this(type, ScriptUtils.idStringToDN(identifiableInfo, delimiter));
        }

        public Builder changeNumber(long changeNumber) {
            this.changeNumber = changeNumber;
            return this;
        }

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder entryType(String entryType) {
            this.entryType = entryType;
            return this;
        }

        public Builder changedColumns(String[] changedColumns) {
            this.changedColumns = changedColumns;
            return this;
        }

        public Builder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        public Builder changeTime(long changeTime) {
            this.changeTime = changeTime;
            return this;
        }

        public Builder addProperty(Object key, Object value) {
            this.properties.put(key, value);
            return this;
        }

        public synchronized DatabaseChangeRecord build() {
            if (this.built) {
                throw new IllegalStateException("This Builder has already been built.");
            }
            this.built = true;
            return new DatabaseChangeRecord(this);
        }
    }

    public static enum ChangeType {
        insert,
        delete,
        update,
        resync;

    }
}

