/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.directory.sdk.sync.types;

import com.unboundid.directory.sdk.sync.types.PostStepResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.Extensible;

@Extensible
public class EndpointException
extends Exception {
    private static final long serialVersionUID = -5331807629501618293L;
    private final PostStepResult retryPolicy;

    public EndpointException(PostStepResult result) {
        this(result, null, null);
    }

    public EndpointException(PostStepResult result, String message) {
        this(result, message, null);
    }

    public EndpointException(PostStepResult result, Throwable cause) {
        this(result, null, cause);
    }

    public EndpointException(PostStepResult result, String message, Throwable cause) {
        super(message, cause);
        this.retryPolicy = result;
        if (result == null) {
            throw new NullPointerException("The PostStepResult cannot be null.");
        }
        if (PostStepResult.CONTINUE.equals((Object)result)) {
            throw new IllegalArgumentException("The PostStepResult parameter cannotbe CONTINUE.");
        }
    }

    public EndpointException(LDAPException cause) {
        super((Throwable)cause);
        this.retryPolicy = null;
    }

    public final PostStepResult getPostStepResult() {
        return this.retryPolicy;
    }
}

