/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.directory.sdk.sync.types;

import java.io.Serializable;
import java.util.Date;

public final class SetStartpointOptions {
    private final StartpointType startpointType;
    private String csnValue;
    private long changeNumber;
    private Date changeTime;
    private Serializable serializableValue;
    private String serverName;

    private SetStartpointOptions(StartpointType startpointType) {
        if (startpointType == null) {
            throw new NullPointerException("The startpointType parameter cannot be null.");
        }
        this.startpointType = startpointType;
    }

    public static SetStartpointOptions createBeginningOfChangelogOptions() {
        SetStartpointOptions options = new SetStartpointOptions(StartpointType.BEGINNING_OF_CHANGELOG);
        return options;
    }

    public static SetStartpointOptions createEndOfChangelogOptions() {
        SetStartpointOptions options = new SetStartpointOptions(StartpointType.END_OF_CHANGELOG);
        return options;
    }

    public static SetStartpointOptions createResumeAtCSNOptions(String csn) {
        if (csn == null) {
            throw new NullPointerException("The CSN parameter cannot be null");
        }
        SetStartpointOptions options = new SetStartpointOptions(StartpointType.RESUME_AT_CSN);
        options.csnValue = csn;
        return options;
    }

    public static SetStartpointOptions createResumeAtChangeNumberOptions(long changeNumber, String serverName) {
        if (serverName == null) {
            throw new NullPointerException("The serverName parameter cannot be null");
        }
        SetStartpointOptions options = new SetStartpointOptions(StartpointType.RESUME_AT_CHANGE_NUMBER);
        options.changeNumber = changeNumber;
        options.serverName = serverName;
        return options;
    }

    public static SetStartpointOptions createResumeAtChangeTimeOptions(Date changeTime, String serverName) {
        if (changeTime == null) {
            throw new NullPointerException("The changeTime parameter cannot be null");
        }
        SetStartpointOptions options = new SetStartpointOptions(StartpointType.RESUME_AT_CHANGE_TIME);
        options.changeTime = changeTime;
        options.serverName = serverName;
        return options;
    }

    public static SetStartpointOptions createResumeAtSerializableOptions(Serializable startpointValue) {
        SetStartpointOptions options = new SetStartpointOptions(StartpointType.RESUME_AT_SERIALIZABLE);
        options.serializableValue = startpointValue;
        return options;
    }

    public StartpointType getStartpointType() {
        return this.startpointType;
    }

    public String getCSN() {
        return this.csnValue;
    }

    public long getChangeNumber() {
        return this.changeNumber;
    }

    public Date getChangeTime() {
        return this.changeTime;
    }

    public Serializable getSerializableValue() {
        return this.serializableValue;
    }

    public String getServerName() {
        return this.serverName;
    }

    public static enum StartpointType {
        RESUME_AT_CSN,
        RESUME_AT_CHANGE_NUMBER,
        RESUME_AT_CHANGE_TIME,
        RESUME_AT_SERIALIZABLE,
        BEGINNING_OF_CHANGELOG,
        END_OF_CHANGELOG;

    }
}

