/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.directory.sdk.sync.types;

import com.unboundid.directory.sdk.sync.util.ScriptUtils;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.util.StaticUtils;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public final class TransactionContext {
    private final Connection connection;
    private static final Timer timer = new Timer(true);
    private TimerTask timeOutTask;
    private long timeOutMs;
    private volatile boolean isTimedOut = false;
    private volatile boolean isClosed = false;

    public TransactionContext(Connection connection) {
        if (connection == null) {
            throw new NullPointerException("Connection is null.");
        }
        this.connection = connection;
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            throw new IllegalStateException("Could not initialize TransactionContext:" + StaticUtils.getExceptionMessage((Throwable)e));
        }
    }

    public synchronized Entry searchToRawEntry(String sql, String rdnColumn) throws SQLException {
        this.checkStatus();
        PreparedStatement stmt = this.connection.prepareStatement(sql);
        return this.searchToRawEntry(stmt, rdnColumn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Entry searchToRawEntry(PreparedStatement statement, String rdnColumn) throws SQLException {
        this.checkStatus();
        ResultSet rset = statement.executeQuery();
        Entry entry = null;
        try {
            if (rset.next()) {
                Object rdnValue = rset.getObject(rdnColumn);
                if (rdnValue == null) {
                    throw new SQLException("The RDN column '" + rdnColumn + "' was not found in the resulting row.");
                }
                entry = new Entry(rdnColumn + "=" + rdnValue);
                ResultSetMetaData metaData = rset.getMetaData();
                for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                    Object o = rset.getObject(i);
                    String attrName = metaData.getColumnLabel(i);
                    String columnClass = metaData.getColumnClassName(i);
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName(columnClass);
                    }
                    catch (ClassNotFoundException e) {
                        throw new SQLException("Couldn't create class for column: " + attrName, e);
                    }
                    if (String.class.isAssignableFrom(clazz)) {
                        String str = (String)o;
                        ScriptUtils.addStringAttribute(entry, attrName, str);
                        continue;
                    }
                    if (Number.class.isAssignableFrom(clazz)) {
                        Number num = (Number)o;
                        ScriptUtils.addNumericAttribute(entry, attrName, num);
                        continue;
                    }
                    if (Date.class.isAssignableFrom(clazz)) {
                        Date date = (Date)o;
                        ScriptUtils.addDateAttribute(entry, attrName, date, true);
                        continue;
                    }
                    if (Character.class.isAssignableFrom(clazz)) {
                        Character c = (Character)o;
                        ScriptUtils.addStringAttribute(entry, attrName, c.toString());
                        continue;
                    }
                    if (Boolean.class.isAssignableFrom(clazz)) {
                        Boolean b = (Boolean)o;
                        ScriptUtils.addBooleanAttribute(entry, attrName, b);
                        continue;
                    }
                    if (Blob.class.isAssignableFrom(clazz)) {
                        Blob blob = (Blob)o;
                        ScriptUtils.addBinaryAttribute(entry, attrName, blob, Integer.MAX_VALUE);
                        continue;
                    }
                    if (Clob.class.isAssignableFrom(clazz)) {
                        Clob clob = (Clob)o;
                        if (clob == null) continue;
                        ScriptUtils.addStringAttribute(entry, attrName, clob.getSubString(1L, Integer.MAX_VALUE));
                        clob.free();
                        continue;
                    }
                    throw new SQLException("Column '" + attrName + "' has an unhandled type: " + columnClass);
                }
            }
            if (rset.next()) {
                throw new SQLException("The query matched more than one row.");
            }
        }
        finally {
            rset.close();
            statement.close();
        }
        return entry;
    }

    public synchronized Statement createStatement() throws SQLException {
        this.checkStatus();
        return this.connection.createStatement();
    }

    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkStatus();
        return this.connection.prepareStatement(sql);
    }

    public synchronized CallableStatement prepareCall(String sql) throws SQLException {
        this.checkStatus();
        return this.connection.prepareCall(sql);
    }

    public synchronized int getTransactionIsolation() throws SQLException {
        this.checkStatus();
        return this.connection.getTransactionIsolation();
    }

    public synchronized void setTransactionIsolation(int level) throws SQLException {
        this.checkStatus();
        this.connection.setTransactionIsolation(level);
    }

    public synchronized void commit() throws SQLException {
        this.checkStatus();
        this.connection.commit();
    }

    public synchronized void rollBack() throws SQLException {
        this.checkStatus();
        this.connection.rollback();
    }

    public synchronized void close() {
        if (this.timeOutTask != null) {
            this.timeOutTask.cancel();
        }
        try {
            this.connection.close();
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.isClosed = true;
        }
    }

    synchronized Connection getConnection() {
        this.checkStatus();
        return this.connection;
    }

    public synchronized void setTimeout(long timeOutMillis) {
        this.checkStatus();
        this.isTimedOut = false;
        this.timeOutMs = timeOutMillis;
        if (this.timeOutTask != null) {
            this.timeOutTask.cancel();
        }
        timer.purge();
        if (timeOutMillis == 0L) {
            return;
        }
        this.timeOutTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    TransactionContext.this.rollBack();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                TransactionContext.this.close();
                TransactionContext.this.isTimedOut = true;
            }
        };
        timer.schedule(this.timeOutTask, timeOutMillis);
    }

    public boolean isTimedOut() {
        return this.isTimedOut;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    private void checkStatus() {
        if (this.isTimedOut) {
            throw new IllegalStateException("The transaction timed out after " + this.timeOutMs + "ms.");
        }
        if (this.isClosed) {
            throw new IllegalStateException("The transaction has already been closed.");
        }
    }
}

