/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.directory.sdk.sync.util;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ScriptUtils {
    private static final String DATE_FORMAT_GMT_TIME = "yyyyMMddHHmmss'Z'";
    private static final String DATE_FORMAT_GENERALIZED_TIME = "yyyyMMddHHmmss.SSS'Z'";
    private static final ThreadLocal<SimpleDateFormat> gmtTime = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat(ScriptUtils.DATE_FORMAT_GMT_TIME);
        }
    };
    private static final ThreadLocal<SimpleDateFormat> generalizedTime = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat(ScriptUtils.DATE_FORMAT_GENERALIZED_TIME);
        }
    };
    private static final Pattern leadingSpaceRE = Pattern.compile("^ *");
    private static final Pattern trailingSpaceRE = Pattern.compile(" *$");

    private ScriptUtils() {
    }

    public static void addStringAttribute(Entry entry, String attrName, String value) {
        if (entry != null && value != null) {
            entry.addAttribute(attrName, value);
        }
    }

    public static void addNumericAttribute(Entry entry, String attrName, Number value) {
        if (entry != null && value != null) {
            entry.addAttribute(attrName, value.toString());
        }
    }

    public static void addBooleanAttribute(Entry entry, String attrName, Boolean value) {
        if (entry != null && value != null) {
            entry.addAttribute(attrName, value.toString());
        }
    }

    public static void addDateAttribute(Entry entry, String attrName, Date date, boolean includeMilliseconds) {
        if (entry != null && date != null) {
            String result = includeMilliseconds ? generalizedTime.get().format(date) : gmtTime.get().format(date);
            entry.addAttribute(attrName, result);
        }
    }

    public static void addBinaryAttribute(Entry entry, String attrName, Blob value, int maxBytes) {
        if (entry != null && value != null) {
            try {
                byte[] bytes = value.getBytes(1L, maxBytes);
                if (bytes.length > 0) {
                    entry.addAttribute(attrName, bytes);
                }
                value.free();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static boolean containsAnyValue(Attribute attr, String ... values) {
        if (attr == null) {
            return false;
        }
        for (String attrValue : attr.getValues()) {
            for (String valueToCheck : values) {
                if (!attrValue.equalsIgnoreCase(valueToCheck)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNullOrEmpty(String value) {
        if (value == null) {
            return true;
        }
        return value.isEmpty();
    }

    public static Timestamp getTimestampFromString(String value) {
        Timestamp ts = null;
        if (value == null) {
            return ts;
        }
        try {
            Date d = generalizedTime.get().parse(value);
            ts = new Timestamp(d.getTime());
            return ts;
        }
        catch (ParseException d) {
            try {
                Date d2 = gmtTime.get().parse(value);
                ts = new Timestamp(d2.getTime());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return ts;
        }
    }

    public static DN idStringToDN(String identifiableInfo, String delimiter) {
        String[] pairs;
        String defaultDelimiter = delimiter;
        if (delimiter == null || delimiter.isEmpty()) {
            defaultDelimiter = "%%";
        }
        ArrayList<RDN> rdnList = new ArrayList<RDN>();
        for (String pair : pairs = identifiableInfo.split(defaultDelimiter)) {
            String[] kv = pair.split("=", 2);
            if (kv.length != 2) {
                throw new IllegalArgumentException("Malformed identifier component: " + pair);
            }
            String key = trailingSpaceRE.matcher(leadingSpaceRE.matcher(kv[0]).replaceAll("")).replaceAll("");
            String value = trailingSpaceRE.matcher(leadingSpaceRE.matcher(kv[1]).replaceAll("")).replaceAll("");
            rdnList.add(new RDN(key, value));
        }
        if (rdnList.isEmpty()) {
            throw new IllegalArgumentException("The identifiableInfo parameter is empty.");
        }
        return new DN(rdnList);
    }

    public static Map<String, String> dnToMap(DN identifiableInfo) {
        HashMap<String, String> ids = new HashMap<String, String>();
        for (RDN rdn : identifiableInfo.getRDNs()) {
            String[] kv = rdn.toString().split("=", 2);
            ids.put(kv[0], kv[1]);
        }
        return ids;
    }
}

