/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.asn1;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1Messages;
import com.unboundid.util.Debug;

public final class ASN1Long
extends ASN1Element {
    private static final long serialVersionUID = -3445506299288414013L;
    private final long longValue;

    public ASN1Long(long l) {
        super((byte)2, ASN1Long.encodeLongValue(l));
        this.longValue = l;
    }

    public ASN1Long(byte by, long l) {
        super(by, ASN1Long.encodeLongValue(l));
        this.longValue = l;
    }

    private ASN1Long(byte by, long l, byte[] byArray) {
        super(by, byArray);
        this.longValue = l;
    }

    static byte[] encodeLongValue(long l) {
        if (l < 0L) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == -128L) {
                return new byte[]{(byte)(l & 0xFFL)};
            }
            if ((l & 0xFFFFFFFFFFFF8000L) == -32768L) {
                return new byte[]{(byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
            }
            if ((l & 0xFFFFFFFFFF800000L) == -8388608L) {
                return new byte[]{(byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
            }
            if ((l & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                return new byte[]{(byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
            }
            if ((l & 0xFFFFFF8000000000L) == -549755813888L) {
                return new byte[]{(byte)(l >> 32 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
            }
            if ((l & 0xFFFF800000000000L) == -140737488355328L) {
                return new byte[]{(byte)(l >> 40 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
            }
            if ((l & 0xFF80000000000000L) == -36028797018963968L) {
                return new byte[]{(byte)(l >> 48 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
            }
            return new byte[]{(byte)(l >> 56 & 0xFFL), (byte)(l >> 48 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
        }
        if ((l & 0x7FL) == l) {
            return new byte[]{(byte)(l & 0x7FL)};
        }
        if ((l & 0x7FFFL) == l) {
            return new byte[]{(byte)(l >> 8 & 0x7FL), (byte)(l & 0xFFL)};
        }
        if ((l & 0x7FFFFFL) == l) {
            return new byte[]{(byte)(l >> 16 & 0x7FL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
        }
        if ((l & Integer.MAX_VALUE) == l) {
            return new byte[]{(byte)(l >> 24 & 0x7FL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
        }
        if ((l & 0x7FFFFFFFFFL) == l) {
            return new byte[]{(byte)(l >> 32 & 0x7FL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
        }
        if ((l & 0x7FFFFFFFFFFFL) == l) {
            return new byte[]{(byte)(l >> 40 & 0x7FL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
        }
        if ((l & 0x7FFFFFFFFFFFFFL) == l) {
            return new byte[]{(byte)(l >> 48 & 0x7FL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
        }
        return new byte[]{(byte)(l >> 56 & 0x7FL), (byte)(l >> 48 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
    }

    public long longValue() {
        return this.longValue;
    }

    public static ASN1Long decodeAsLong(byte[] byArray) throws ASN1Exception {
        try {
            long l;
            int n = 2;
            int n2 = byArray[1] & 0x7F;
            if (n2 != byArray[1]) {
                int n3 = n2;
                n2 = 0;
                for (int i = 0; i < n3; ++i) {
                    n2 <<= 8;
                    n2 |= byArray[n++] & 0xFF;
                }
            }
            if (byArray.length - n != n2) {
                throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_LENGTH_MISMATCH.get(n2, byArray.length - n));
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            switch (byArray2.length) {
                case 1: {
                    l = (long)byArray2[0] & 0xFFL;
                    if (((long)byArray2[0] & 0x80L) == 0L) break;
                    l |= 0xFFFFFFFFFFFFFF00L;
                    break;
                }
                case 2: {
                    l = ((long)byArray2[0] & 0xFFL) << 8 | (long)byArray2[1] & 0xFFL;
                    if (((long)byArray2[0] & 0x80L) == 0L) break;
                    l |= 0xFFFFFFFFFFFF0000L;
                    break;
                }
                case 3: {
                    l = ((long)byArray2[0] & 0xFFL) << 16 | ((long)byArray2[1] & 0xFFL) << 8 | (long)byArray2[2] & 0xFFL;
                    if (((long)byArray2[0] & 0x80L) == 0L) break;
                    l |= 0xFFFFFFFFFF000000L;
                    break;
                }
                case 4: {
                    l = ((long)byArray2[0] & 0xFFL) << 24 | ((long)byArray2[1] & 0xFFL) << 16 | ((long)byArray2[2] & 0xFFL) << 8 | (long)byArray2[3] & 0xFFL;
                    if (((long)byArray2[0] & 0x80L) == 0L) break;
                    l |= 0xFFFFFFFF00000000L;
                    break;
                }
                case 5: {
                    l = ((long)byArray2[0] & 0xFFL) << 32 | ((long)byArray2[1] & 0xFFL) << 24 | ((long)byArray2[2] & 0xFFL) << 16 | ((long)byArray2[3] & 0xFFL) << 8 | (long)byArray2[4] & 0xFFL;
                    if (((long)byArray2[0] & 0x80L) == 0L) break;
                    l |= 0xFFFFFF0000000000L;
                    break;
                }
                case 6: {
                    l = ((long)byArray2[0] & 0xFFL) << 40 | ((long)byArray2[1] & 0xFFL) << 32 | ((long)byArray2[2] & 0xFFL) << 24 | ((long)byArray2[3] & 0xFFL) << 16 | ((long)byArray2[4] & 0xFFL) << 8 | (long)byArray2[5] & 0xFFL;
                    if (((long)byArray2[0] & 0x80L) == 0L) break;
                    l |= 0xFFFF000000000000L;
                    break;
                }
                case 7: {
                    l = ((long)byArray2[0] & 0xFFL) << 48 | ((long)byArray2[1] & 0xFFL) << 40 | ((long)byArray2[2] & 0xFFL) << 32 | ((long)byArray2[3] & 0xFFL) << 24 | ((long)byArray2[4] & 0xFFL) << 16 | ((long)byArray2[5] & 0xFFL) << 8 | (long)byArray2[6] & 0xFFL;
                    if (((long)byArray2[0] & 0x80L) == 0L) break;
                    l |= 0xFF00000000000000L;
                    break;
                }
                case 8: {
                    l = ((long)byArray2[0] & 0xFFL) << 56 | ((long)byArray2[1] & 0xFFL) << 48 | ((long)byArray2[2] & 0xFFL) << 40 | ((long)byArray2[3] & 0xFFL) << 32 | ((long)byArray2[4] & 0xFFL) << 24 | ((long)byArray2[5] & 0xFFL) << 16 | ((long)byArray2[6] & 0xFFL) << 8 | (long)byArray2[7] & 0xFFL;
                    break;
                }
                default: {
                    throw new ASN1Exception(ASN1Messages.ERR_LONG_INVALID_LENGTH.get(byArray2.length));
                }
            }
            return new ASN1Long(byArray[0], l, byArray2);
        }
        catch (ASN1Exception aSN1Exception) {
            Debug.debugException(aSN1Exception);
            throw aSN1Exception;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_DECODE_EXCEPTION.get(exception), exception);
        }
    }

    public static ASN1Long decodeAsLong(ASN1Element aSN1Element) throws ASN1Exception {
        long l;
        byte[] byArray = aSN1Element.getValue();
        switch (byArray.length) {
            case 1: {
                l = (long)byArray[0] & 0xFFL;
                if (((long)byArray[0] & 0x80L) == 0L) break;
                l |= 0xFFFFFFFFFFFFFF00L;
                break;
            }
            case 2: {
                l = ((long)byArray[0] & 0xFFL) << 8 | (long)byArray[1] & 0xFFL;
                if (((long)byArray[0] & 0x80L) == 0L) break;
                l |= 0xFFFFFFFFFFFF0000L;
                break;
            }
            case 3: {
                l = ((long)byArray[0] & 0xFFL) << 16 | ((long)byArray[1] & 0xFFL) << 8 | (long)byArray[2] & 0xFFL;
                if (((long)byArray[0] & 0x80L) == 0L) break;
                l |= 0xFFFFFFFFFF000000L;
                break;
            }
            case 4: {
                l = ((long)byArray[0] & 0xFFL) << 24 | ((long)byArray[1] & 0xFFL) << 16 | ((long)byArray[2] & 0xFFL) << 8 | (long)byArray[3] & 0xFFL;
                if (((long)byArray[0] & 0x80L) == 0L) break;
                l |= 0xFFFFFFFF00000000L;
                break;
            }
            case 5: {
                l = ((long)byArray[0] & 0xFFL) << 32 | ((long)byArray[1] & 0xFFL) << 24 | ((long)byArray[2] & 0xFFL) << 16 | ((long)byArray[3] & 0xFFL) << 8 | (long)byArray[4] & 0xFFL;
                if (((long)byArray[0] & 0x80L) == 0L) break;
                l |= 0xFFFFFF0000000000L;
                break;
            }
            case 6: {
                l = ((long)byArray[0] & 0xFFL) << 40 | ((long)byArray[1] & 0xFFL) << 32 | ((long)byArray[2] & 0xFFL) << 24 | ((long)byArray[3] & 0xFFL) << 16 | ((long)byArray[4] & 0xFFL) << 8 | (long)byArray[5] & 0xFFL;
                if (((long)byArray[0] & 0x80L) == 0L) break;
                l |= 0xFFFF000000000000L;
                break;
            }
            case 7: {
                l = ((long)byArray[0] & 0xFFL) << 48 | ((long)byArray[1] & 0xFFL) << 40 | ((long)byArray[2] & 0xFFL) << 32 | ((long)byArray[3] & 0xFFL) << 24 | ((long)byArray[4] & 0xFFL) << 16 | ((long)byArray[5] & 0xFFL) << 8 | (long)byArray[6] & 0xFFL;
                if (((long)byArray[0] & 0x80L) == 0L) break;
                l |= 0xFF00000000000000L;
                break;
            }
            case 8: {
                l = ((long)byArray[0] & 0xFFL) << 56 | ((long)byArray[1] & 0xFFL) << 48 | ((long)byArray[2] & 0xFFL) << 40 | ((long)byArray[3] & 0xFFL) << 32 | ((long)byArray[4] & 0xFFL) << 24 | ((long)byArray[5] & 0xFFL) << 16 | ((long)byArray[6] & 0xFFL) << 8 | (long)byArray[7] & 0xFFL;
                break;
            }
            default: {
                throw new ASN1Exception(ASN1Messages.ERR_LONG_INVALID_LENGTH.get(byArray.length));
            }
        }
        return new ASN1Long(aSN1Element.getType(), l, byArray);
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append(this.longValue);
    }
}

