/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.asn1;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1Messages;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.asn1.ASN1StreamReaderSet;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.util.logging.Level;
import javax.security.sasl.SaslClient;

public final class ASN1StreamReader
implements Closeable {
    private boolean ignoreInitialSocketTimeout;
    private boolean ignoreSubsequentSocketTimeout;
    private volatile ByteArrayInputStream saslInputStream;
    private final InputStream inputStream;
    private final int maxElementSize;
    private long totalBytesRead;
    private volatile SaslClient saslClient;

    public ASN1StreamReader(InputStream inputStream) {
        this(inputStream, Integer.MAX_VALUE);
    }

    public ASN1StreamReader(InputStream inputStream, int n) {
        this.inputStream = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream);
        this.maxElementSize = n > 0 ? n : Integer.MAX_VALUE;
        this.totalBytesRead = 0L;
        this.ignoreInitialSocketTimeout = false;
        this.ignoreSubsequentSocketTimeout = false;
        this.saslClient = null;
        this.saslInputStream = null;
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    long getTotalBytesRead() {
        return this.totalBytesRead;
    }

    @Deprecated
    public boolean ignoreSocketTimeoutException() {
        return this.ignoreInitialSocketTimeout;
    }

    public boolean ignoreInitialSocketTimeoutException() {
        return this.ignoreInitialSocketTimeout;
    }

    public boolean ignoreSubsequentSocketTimeoutException() {
        return this.ignoreSubsequentSocketTimeout;
    }

    @Deprecated
    public void setIgnoreSocketTimeout(boolean bl) {
        this.ignoreInitialSocketTimeout = bl;
        this.ignoreSubsequentSocketTimeout = bl;
    }

    public void setIgnoreSocketTimeout(boolean bl, boolean bl2) {
        this.ignoreInitialSocketTimeout = bl;
        this.ignoreSubsequentSocketTimeout = bl2;
    }

    public int peek() throws IOException {
        InputStream inputStream;
        if (this.saslClient == null) {
            inputStream = this.inputStream;
        } else {
            if (this.saslInputStream == null) {
                this.readAndDecodeSASLData(-1);
            }
            inputStream = this.saslInputStream;
        }
        inputStream.mark(1);
        int n = this.read(true);
        inputStream.reset();
        return n;
    }

    private int readType() throws IOException {
        int n = this.read(true);
        if (n < 0) {
            this.close();
        } else {
            ++this.totalBytesRead;
        }
        return n;
    }

    private int readLength() throws IOException {
        int n = this.read(false);
        if (n < 0) {
            throw new IOException(ASN1Messages.ERR_READ_END_BEFORE_FIRST_LENGTH.get());
        }
        ++this.totalBytesRead;
        if (n > 127) {
            int n2 = n & 0x7F;
            n = 0;
            if (n2 < 1 || n2 > 4) {
                throw new IOException(ASN1Messages.ERR_READ_LENGTH_TOO_LONG.get(n2));
            }
            for (int i = 0; i < n2; ++i) {
                int n3 = this.read(false);
                if (n3 < 0) {
                    throw new IOException(ASN1Messages.ERR_READ_END_BEFORE_LENGTH_END.get());
                }
                n <<= 8;
                n |= n3 & 0xFF;
            }
            this.totalBytesRead += (long)n2;
        }
        if (n < 0 || this.maxElementSize > 0 && n > this.maxElementSize) {
            throw new IOException(ASN1Messages.ERR_READ_LENGTH_EXCEEDS_MAX.get(n, this.maxElementSize));
        }
        return n;
    }

    private void skip(int n) throws IOException {
        if (n <= 0) {
            return;
        }
        if (this.saslClient != null) {
            int n2;
            int n3 = 0;
            byte[] byArray = new byte[n];
            do {
                if ((n2 = this.read(byArray, n3, n - n3)) < 0) {
                    return;
                }
                this.totalBytesRead += (long)n2;
            } while ((n3 += n2) < n);
            return;
        }
        long l = this.inputStream.skip(n);
        while (l < (long)n) {
            long l2 = this.inputStream.skip((long)n - l);
            if (l2 <= 0L) {
                while (l < (long)n) {
                    int n4 = this.read(false);
                    if (n4 < 0) {
                        throw new IOException(ASN1Messages.ERR_READ_END_BEFORE_VALUE_END.get());
                    }
                    ++l;
                }
                continue;
            }
            l += l2;
        }
        this.totalBytesRead += (long)n;
    }

    public ASN1Element readElement() throws IOException {
        int n = this.readType();
        if (n < 0) {
            return null;
        }
        int n2 = this.readLength();
        int n3 = 0;
        int n4 = n2;
        byte[] byArray = new byte[n2];
        while (n3 < n2) {
            int n5 = this.read(byArray, n3, n4);
            if (n5 < 0) {
                throw new IOException(ASN1Messages.ERR_READ_END_BEFORE_VALUE_END.get());
            }
            n3 += n5;
            n4 -= n5;
        }
        this.totalBytesRead += (long)n2;
        ASN1Element aSN1Element = new ASN1Element((byte)n, byArray);
        Debug.debugASN1Read(aSN1Element);
        return aSN1Element;
    }

    public Boolean readBoolean() throws IOException, ASN1Exception {
        int n = this.readType();
        if (n < 0) {
            return null;
        }
        int n2 = this.readLength();
        if (n2 == 1) {
            int n3 = this.read(false);
            if (n3 < 0) {
                throw new IOException(ASN1Messages.ERR_READ_END_BEFORE_VALUE_END.get());
            }
            ++this.totalBytesRead;
            Boolean bl = n3 != 0;
            Debug.debugASN1Read(Level.INFO, "Boolean", n, 1, bl);
            return bl;
        }
        this.skip(n2);
        throw new ASN1Exception(ASN1Messages.ERR_BOOLEAN_INVALID_LENGTH.get());
    }

    public Integer readEnumerated() throws IOException, ASN1Exception {
        return this.readInteger();
    }

    public Integer readInteger() throws IOException, ASN1Exception {
        int n = this.readType();
        if (n < 0) {
            return null;
        }
        int n2 = this.readLength();
        if (n2 == 0 || n2 > 4) {
            this.skip(n2);
            throw new ASN1Exception(ASN1Messages.ERR_INTEGER_INVALID_LENGTH.get(n2));
        }
        boolean bl = false;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = this.read(false);
            if (n4 < 0) {
                throw new IOException(ASN1Messages.ERR_READ_END_BEFORE_VALUE_END.get());
            }
            if (i == 0) {
                bl = (n4 & 0x80) != 0;
            }
            n3 <<= 8;
            n3 |= n4 & 0xFF;
        }
        if (bl) {
            switch (n2) {
                case 1: {
                    n3 |= 0xFFFFFF00;
                    break;
                }
                case 2: {
                    n3 |= 0xFFFF0000;
                    break;
                }
                case 3: {
                    n3 |= 0xFF000000;
                }
            }
        }
        this.totalBytesRead += (long)n2;
        Debug.debugASN1Read(Level.INFO, "Integer", n, n2, n3);
        return n3;
    }

    public Long readLong() throws IOException, ASN1Exception {
        int n = this.readType();
        if (n < 0) {
            return null;
        }
        int n2 = this.readLength();
        if (n2 == 0 || n2 > 8) {
            this.skip(n2);
            throw new ASN1Exception(ASN1Messages.ERR_LONG_INVALID_LENGTH.get(n2));
        }
        boolean bl = false;
        long l = 0L;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.read(false);
            if (n3 < 0) {
                throw new IOException(ASN1Messages.ERR_READ_END_BEFORE_VALUE_END.get());
            }
            if (i == 0) {
                bl = (n3 & 0x80) != 0;
            }
            l <<= 8;
            l |= (long)n3 & 0xFFL;
        }
        if (bl) {
            switch (n2) {
                case 1: {
                    l |= 0xFFFFFFFFFFFFFF00L;
                    break;
                }
                case 2: {
                    l |= 0xFFFFFFFFFFFF0000L;
                    break;
                }
                case 3: {
                    l |= 0xFFFFFFFFFF000000L;
                    break;
                }
                case 4: {
                    l |= 0xFFFFFFFF00000000L;
                    break;
                }
                case 5: {
                    l |= 0xFFFFFF0000000000L;
                    break;
                }
                case 6: {
                    l |= 0xFFFF000000000000L;
                    break;
                }
                case 7: {
                    l |= 0xFF00000000000000L;
                }
            }
        }
        this.totalBytesRead += (long)n2;
        Debug.debugASN1Read(Level.INFO, "Long", n, n2, l);
        return l;
    }

    public void readNull() throws IOException, ASN1Exception {
        int n = this.readType();
        if (n < 0) {
            return;
        }
        int n2 = this.readLength();
        if (n2 != 0) {
            this.skip(n2);
            throw new ASN1Exception(ASN1Messages.ERR_NULL_HAS_VALUE.get());
        }
        Debug.debugASN1Read(Level.INFO, "Null", n, 0, null);
    }

    public byte[] readBytes() throws IOException {
        int n = this.readType();
        if (n < 0) {
            return null;
        }
        int n2 = this.readLength();
        int n3 = 0;
        int n4 = n2;
        byte[] byArray = new byte[n2];
        while (n3 < n2) {
            int n5 = this.read(byArray, n3, n4);
            if (n5 < 0) {
                throw new IOException(ASN1Messages.ERR_READ_END_BEFORE_VALUE_END.get());
            }
            n3 += n5;
            n4 -= n5;
        }
        this.totalBytesRead += (long)n2;
        Debug.debugASN1Read(Level.INFO, "byte[]", n, n2, byArray);
        return byArray;
    }

    public String readString() throws IOException {
        int n = this.readType();
        if (n < 0) {
            return null;
        }
        int n2 = this.readLength();
        int n3 = 0;
        int n4 = n2;
        byte[] byArray = new byte[n2];
        while (n3 < n2) {
            int n5 = this.read(byArray, n3, n4);
            if (n5 < 0) {
                throw new IOException(ASN1Messages.ERR_READ_END_BEFORE_VALUE_END.get());
            }
            n3 += n5;
            n4 -= n5;
        }
        this.totalBytesRead += (long)n2;
        String string = StaticUtils.toUTF8String(byArray);
        Debug.debugASN1Read(Level.INFO, "String", n, n2, string);
        return string;
    }

    public ASN1StreamReaderSequence beginSequence() throws IOException {
        int n = this.readType();
        if (n < 0) {
            return null;
        }
        int n2 = this.readLength();
        Debug.debugASN1Read(Level.INFO, "Sequence Header", n, n2, null);
        return new ASN1StreamReaderSequence(this, (byte)n, n2);
    }

    public ASN1StreamReaderSet beginSet() throws IOException {
        int n = this.readType();
        if (n < 0) {
            return null;
        }
        int n2 = this.readLength();
        Debug.debugASN1Read(Level.INFO, "Set Header", n, n2, null);
        return new ASN1StreamReaderSet(this, (byte)n, n2);
    }

    private int read(boolean bl) throws IOException {
        if (this.saslClient != null) {
            int n;
            if (this.saslInputStream != null && (n = this.saslInputStream.read()) >= 0) {
                return n;
            }
            this.readAndDecodeSASLData(-1);
            return this.saslInputStream.read();
        }
        try {
            int n = this.inputStream.read();
            if (this.saslClient == null || n < 0) {
                return n;
            }
            this.readAndDecodeSASLData(n);
            return this.saslInputStream.read();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            Debug.debugException(Level.FINEST, socketTimeoutException);
            if (bl && this.ignoreInitialSocketTimeout || !bl && this.ignoreSubsequentSocketTimeout) {
                while (true) {
                    try {
                        return this.inputStream.read();
                    }
                    catch (SocketTimeoutException socketTimeoutException2) {
                        Debug.debugException(Level.FINEST, socketTimeoutException2);
                        continue;
                    }
                    break;
                }
            }
            throw socketTimeoutException;
        }
    }

    private int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.saslClient != null) {
            int n3;
            if (this.saslInputStream != null && (n3 = this.saslInputStream.read(byArray, n, n2)) > 0) {
                return n3;
            }
            this.readAndDecodeSASLData(-1);
            return this.saslInputStream.read(byArray, n, n2);
        }
        try {
            return this.inputStream.read(byArray, n, n2);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            Debug.debugException(Level.FINEST, socketTimeoutException);
            if (this.ignoreSubsequentSocketTimeout) {
                while (true) {
                    try {
                        return this.inputStream.read(byArray, n, n2);
                    }
                    catch (SocketTimeoutException socketTimeoutException2) {
                        Debug.debugException(Level.FINEST, socketTimeoutException2);
                        continue;
                    }
                    break;
                }
            }
            throw socketTimeoutException;
        }
    }

    void setSASLClient(SaslClient saslClient) {
        this.saslClient = saslClient;
    }

    private void readAndDecodeSASLData(int n) throws IOException {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 4;
        if (n >= 0) {
            n5 = 3;
            n4 = n;
        }
        for (n3 = 0; n3 < n5; ++n3) {
            int n6 = this.inputStream.read();
            if (n6 < 0) {
                if (n3 == 0 && n < 0) {
                    this.saslInputStream = new ByteArrayInputStream(StaticUtils.NO_BYTES);
                    continue;
                }
                throw new IOException(ASN1Messages.ERR_STREAM_READER_EOS_READING_SASL_LENGTH.get(n3));
            }
            n4 = n4 << 8 | n6 & 0xFF;
        }
        if (this.maxElementSize > 0 && n4 > this.maxElementSize) {
            throw new IOException(ASN1Messages.ERR_READ_SASL_LENGTH_EXCEEDS_MAX.get(n4, this.maxElementSize));
        }
        n3 = 0;
        byte[] byArray = new byte[n4];
        do {
            if ((n2 = this.inputStream.read(byArray, n3, n4 - n3)) >= 0) continue;
            throw new IOException(ASN1Messages.ERR_STREAM_READER_EOS_READING_SASL_DATA.get(n3, n4));
        } while ((n3 += n2) < n4);
        byte[] byArray2 = this.saslClient.unwrap(byArray, 0, n4);
        this.saslInputStream = new ByteArrayInputStream(byArray2, 0, byArray2.length);
    }
}

