/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.asn1;

import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1Messages;
import com.unboundid.asn1.ASN1StreamReader;

public final class ASN1StreamReaderSet {
    private final ASN1StreamReader reader;
    private final byte type;
    private final int length;
    private final long endBytesRead;

    ASN1StreamReaderSet(ASN1StreamReader aSN1StreamReader, byte by, int n) {
        this.reader = aSN1StreamReader;
        this.type = by;
        this.length = n;
        this.endBytesRead = aSN1StreamReader.getTotalBytesRead() + (long)n;
    }

    public byte getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public boolean hasMoreElements() throws ASN1Exception {
        long l = this.reader.getTotalBytesRead();
        if (l == this.endBytesRead) {
            return false;
        }
        if (l < this.endBytesRead) {
            return true;
        }
        throw new ASN1Exception(ASN1Messages.ERR_STREAM_READER_SET_READ_PAST_END.get(this.length, this.endBytesRead, l));
    }
}

