/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.asn1;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

public final class ASN1Writer {
    private static final ThreadLocal<ByteStringBuffer> buffers = new ThreadLocal();
    private static final int MAX_BUFFER_LENGTH = 524288;

    private ASN1Writer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeElement(ASN1Element aSN1Element, OutputStream outputStream) throws IOException {
        Debug.debugASN1Write(aSN1Element);
        ByteStringBuffer byteStringBuffer = buffers.get();
        if (byteStringBuffer == null) {
            byteStringBuffer = new ByteStringBuffer();
            buffers.set(byteStringBuffer);
        }
        aSN1Element.encodeTo(byteStringBuffer);
        try {
            byteStringBuffer.write(outputStream);
        }
        finally {
            if (byteStringBuffer.capacity() > 524288) {
                byteStringBuffer.setCapacity(524288);
            }
            byteStringBuffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeElement(ASN1Element aSN1Element, ByteBuffer byteBuffer) throws BufferOverflowException {
        Debug.debugASN1Write(aSN1Element);
        ByteStringBuffer byteStringBuffer = buffers.get();
        if (byteStringBuffer == null) {
            byteStringBuffer = new ByteStringBuffer();
            buffers.set(byteStringBuffer);
        }
        aSN1Element.encodeTo(byteStringBuffer);
        try {
            if (byteBuffer.remaining() < byteStringBuffer.length()) {
                throw new BufferOverflowException();
            }
            int n = byteBuffer.position();
            byteBuffer.put(byteStringBuffer.getBackingArray(), 0, byteStringBuffer.length());
            byteBuffer.limit(byteBuffer.position());
            byteBuffer.position(n);
        }
        finally {
            if (byteStringBuffer.capacity() > 524288) {
                byteStringBuffer.setCapacity(524288);
            }
            byteStringBuffer.clear();
        }
    }
}

