/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.matchingrules;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.matchingrules.MatchingRuleMessages;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.StaticUtils;

public final class BooleanMatchingRule
extends MatchingRule {
    private static final BooleanMatchingRule INSTANCE = new BooleanMatchingRule();
    private static final ASN1OctetString TRUE_VALUE = new ASN1OctetString("TRUE");
    private static final ASN1OctetString FALSE_VALUE = new ASN1OctetString("FALSE");
    public static final String EQUALITY_RULE_NAME = "booleanMatch";
    static final String LOWER_EQUALITY_RULE_NAME = StaticUtils.toLowerCase("booleanMatch");
    public static final String EQUALITY_RULE_OID = "2.5.13.13";
    private static final long serialVersionUID = 5137725892611277972L;

    public static BooleanMatchingRule getInstance() {
        return INSTANCE;
    }

    public String getEqualityMatchingRuleName() {
        return EQUALITY_RULE_NAME;
    }

    public String getEqualityMatchingRuleOID() {
        return EQUALITY_RULE_OID;
    }

    public String getOrderingMatchingRuleName() {
        return null;
    }

    public String getOrderingMatchingRuleOID() {
        return null;
    }

    public String getSubstringMatchingRuleName() {
        return null;
    }

    public String getSubstringMatchingRuleOID() {
        return null;
    }

    public boolean valuesMatch(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2) throws LDAPException {
        return this.normalize(aSN1OctetString).equals(this.normalize(aSN1OctetString2));
    }

    public boolean matchesSubstring(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2, ASN1OctetString[] aSN1OctetStringArray, ASN1OctetString aSN1OctetString3) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_BOOLEAN_SUBSTRING_MATCHING_NOT_SUPPORTED.get());
    }

    public int compareValues(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_BOOLEAN_ORDERING_MATCHING_NOT_SUPPORTED.get());
    }

    public ASN1OctetString normalize(ASN1OctetString aSN1OctetString) throws LDAPException {
        byte[] byArray = aSN1OctetString.getValue();
        if (!(byArray.length != 4 || byArray[0] != 84 && byArray[0] != 116 || byArray[1] != 82 && byArray[1] != 114 || byArray[2] != 85 && byArray[2] != 117 || byArray[3] != 69 && byArray[3] != 101)) {
            return TRUE_VALUE;
        }
        if (!(byArray.length != 5 || byArray[0] != 70 && byArray[0] != 102 || byArray[1] != 65 && byArray[1] != 97 || byArray[2] != 76 && byArray[2] != 108 || byArray[3] != 83 && byArray[3] != 115 || byArray[4] != 69 && byArray[4] != 101)) {
            return FALSE_VALUE;
        }
        throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_BOOLEAN_INVALID_VALUE.get());
    }

    public ASN1OctetString normalizeSubstring(ASN1OctetString aSN1OctetString, byte by) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_BOOLEAN_SUBSTRING_MATCHING_NOT_SUPPORTED.get());
    }
}

