/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.matchingrules;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.AcceptAllSimpleMatchingRule;
import com.unboundid.util.StaticUtils;

public final class CaseExactStringMatchingRule
extends AcceptAllSimpleMatchingRule {
    private static final CaseExactStringMatchingRule INSTANCE = new CaseExactStringMatchingRule();
    public static final String EQUALITY_RULE_NAME = "caseExactMatch";
    static final String LOWER_EQUALITY_RULE_NAME = StaticUtils.toLowerCase("caseExactMatch");
    public static final String EQUALITY_RULE_OID = "2.5.13.5";
    public static final String ORDERING_RULE_NAME = "caseExactOrderingMatch";
    static final String LOWER_ORDERING_RULE_NAME = StaticUtils.toLowerCase("caseExactOrderingMatch");
    public static final String ORDERING_RULE_OID = "2.5.13.6";
    public static final String SUBSTRING_RULE_NAME = "caseExactSubstringsMatch";
    static final String LOWER_SUBSTRING_RULE_NAME = StaticUtils.toLowerCase("caseExactSubstringsMatch");
    public static final String SUBSTRING_RULE_OID = "2.5.13.7";
    private static final long serialVersionUID = -6336492464430413364L;

    public static CaseExactStringMatchingRule getInstance() {
        return INSTANCE;
    }

    public String getEqualityMatchingRuleName() {
        return EQUALITY_RULE_NAME;
    }

    public String getEqualityMatchingRuleOID() {
        return EQUALITY_RULE_OID;
    }

    public String getOrderingMatchingRuleName() {
        return ORDERING_RULE_NAME;
    }

    public String getOrderingMatchingRuleOID() {
        return ORDERING_RULE_OID;
    }

    public String getSubstringMatchingRuleName() {
        return SUBSTRING_RULE_NAME;
    }

    public String getSubstringMatchingRuleOID() {
        return SUBSTRING_RULE_OID;
    }

    public boolean valuesMatch(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2) {
        byte[] byArray;
        byte[] byArray2 = aSN1OctetString.getValue();
        if (byArray2.length == (byArray = aSN1OctetString2.getValue()).length) {
            for (int i = 0; i < byArray2.length; ++i) {
                byte by = byArray2[i];
                byte by2 = byArray[i];
                if ((by & 0x7F) != (by & 0xFF) || (by2 & 0x7F) != (by2 & 0xFF)) {
                    return this.normalize(aSN1OctetString).equals(this.normalize(aSN1OctetString2));
                }
                if (by == by2) continue;
                if (by == 32 || by2 == 32) {
                    return this.normalize(aSN1OctetString).equals(this.normalize(aSN1OctetString2));
                }
                return false;
            }
            return true;
        }
        return CaseExactStringMatchingRule.normalizeInternal(aSN1OctetString, false, (byte)0).equals(CaseExactStringMatchingRule.normalizeInternal(aSN1OctetString2, false, (byte)0));
    }

    public ASN1OctetString normalize(ASN1OctetString aSN1OctetString) {
        return CaseExactStringMatchingRule.normalizeInternal(aSN1OctetString, false, (byte)0);
    }

    public ASN1OctetString normalizeSubstring(ASN1OctetString aSN1OctetString, byte by) {
        return CaseExactStringMatchingRule.normalizeInternal(aSN1OctetString, true, by);
    }

    private static ASN1OctetString normalizeInternal(ASN1OctetString aSN1OctetString, boolean bl, byte by) {
        int n;
        boolean bl2;
        boolean bl3;
        byte[] byArray = aSN1OctetString.getValue();
        if (byArray.length == 0) {
            return aSN1OctetString;
        }
        if (bl) {
            switch (by) {
                case -128: {
                    bl3 = true;
                    bl2 = false;
                    break;
                }
                case -126: {
                    bl3 = false;
                    bl2 = true;
                    break;
                }
                default: {
                    bl3 = false;
                    bl2 = false;
                    break;
                }
            }
        } else {
            bl3 = true;
            bl2 = true;
        }
        boolean bl4 = false;
        boolean bl5 = bl3;
        int n2 = 0;
        byte[] byArray2 = byArray;
        int n3 = byArray2.length;
        for (n = 0; n < n3; ++n) {
            byte by2 = byArray2[n];
            if ((by2 & 0x7F) != (by2 & 0xFF)) {
                return CaseExactStringMatchingRule.normalizeNonASCII(aSN1OctetString, bl3, bl2);
            }
            if (by2 == 32) {
                if (bl5) {
                    ++n2;
                    continue;
                }
                bl5 = true;
                continue;
            }
            bl4 = true;
            bl5 = false;
        }
        if (!bl4) {
            return new ASN1OctetString(" ");
        }
        if (bl5 && bl2) {
            ++n2;
        }
        bl5 = bl3;
        int n4 = 0;
        byte[] byArray3 = new byte[byArray.length - n2];
        for (n = 0; n < byArray.length; ++n) {
            if (byArray[n] == 32) {
                if (bl5 || bl2 && n == byArray.length - 1 || n4 >= byArray3.length) continue;
                byArray3[n4++] = 32;
                bl5 = true;
                continue;
            }
            byArray3[n4++] = byArray[n];
            bl5 = false;
        }
        return new ASN1OctetString(byArray3);
    }

    private static ASN1OctetString normalizeNonASCII(ASN1OctetString aSN1OctetString, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder(aSN1OctetString.stringValue());
        int n = 0;
        boolean bl3 = bl;
        while (n < stringBuilder.length()) {
            char c;
            if ((c = stringBuilder.charAt(n++)) == ' ') {
                if (bl3 || bl2 && n >= stringBuilder.length()) {
                    stringBuilder.deleteCharAt(--n);
                    continue;
                }
                bl3 = true;
                continue;
            }
            bl3 = false;
        }
        if (bl2 && stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == ' ') {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return new ASN1OctetString(stringBuilder.toString());
    }
}

