/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.matchingrules;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.CaseIgnoreStringMatchingRule;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.matchingrules.MatchingRuleMessages;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CaseIgnoreListMatchingRule
extends MatchingRule {
    private static final CaseIgnoreListMatchingRule INSTANCE = new CaseIgnoreListMatchingRule();
    public static final String EQUALITY_RULE_NAME = "caseIgnoreListMatch";
    static final String LOWER_EQUALITY_RULE_NAME = StaticUtils.toLowerCase("caseIgnoreListMatch");
    public static final String EQUALITY_RULE_OID = "2.5.13.11";
    public static final String SUBSTRING_RULE_NAME = "caseIgnoreListSubstringsMatch";
    static final String LOWER_SUBSTRING_RULE_NAME = StaticUtils.toLowerCase("caseIgnoreListSubstringsMatch");
    public static final String SUBSTRING_RULE_OID = "2.5.13.12";
    private static final long serialVersionUID = 7795143670808983466L;

    public static CaseIgnoreListMatchingRule getInstance() {
        return INSTANCE;
    }

    @Override
    public String getEqualityMatchingRuleName() {
        return EQUALITY_RULE_NAME;
    }

    @Override
    public String getEqualityMatchingRuleOID() {
        return EQUALITY_RULE_OID;
    }

    @Override
    public String getOrderingMatchingRuleName() {
        return null;
    }

    @Override
    public String getOrderingMatchingRuleOID() {
        return null;
    }

    @Override
    public String getSubstringMatchingRuleName() {
        return SUBSTRING_RULE_NAME;
    }

    @Override
    public String getSubstringMatchingRuleOID() {
        return SUBSTRING_RULE_OID;
    }

    @Override
    public boolean valuesMatch(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2) throws LDAPException {
        return this.normalize(aSN1OctetString).equals(this.normalize(aSN1OctetString2));
    }

    @Override
    public boolean matchesSubstring(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2, ASN1OctetString[] aSN1OctetStringArray, ASN1OctetString aSN1OctetString3) throws LDAPException {
        Object object;
        String string = this.normalize(aSN1OctetString).stringValue();
        if (aSN1OctetString2 != null) {
            object = this.normalizeSubstring(aSN1OctetString2, (byte)-128).stringValue();
            if (((String)object).indexOf(36) >= 0) {
                throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_CASE_IGNORE_LIST_SUBSTRING_COMPONENT_CONTAINS_DOLLAR.get(object));
            }
            if (!string.startsWith((String)object)) {
                return false;
            }
            string = string.substring(((String)object).length());
        }
        if (aSN1OctetString3 != null) {
            object = this.normalizeSubstring(aSN1OctetString3, (byte)-126).stringValue();
            if (((String)object).indexOf(36) >= 0) {
                throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_CASE_IGNORE_LIST_SUBSTRING_COMPONENT_CONTAINS_DOLLAR.get(object));
            }
            if (!string.endsWith((String)object)) {
                return false;
            }
            string = string.substring(0, string.length() - ((String)object).length());
        }
        if (aSN1OctetStringArray != null) {
            for (ASN1OctetString aSN1OctetString4 : aSN1OctetStringArray) {
                String string2 = this.normalizeSubstring(aSN1OctetString4, (byte)-127).stringValue();
                if (string2.indexOf(36) >= 0) {
                    throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_CASE_IGNORE_LIST_SUBSTRING_COMPONENT_CONTAINS_DOLLAR.get(string2));
                }
                int n = string.indexOf(string2);
                if (n < 0) {
                    return false;
                }
                string = string.substring(n + string2.length());
            }
        }
        return true;
    }

    @Override
    public int compareValues(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_CASE_IGNORE_LIST_ORDERING_MATCHING_NOT_SUPPORTED.get());
    }

    @Override
    public ASN1OctetString normalize(ASN1OctetString aSN1OctetString) throws LDAPException {
        List<String> list = CaseIgnoreListMatchingRule.getLowercaseItems(aSN1OctetString);
        Iterator<String> iterator = list.iterator();
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            CaseIgnoreListMatchingRule.normalizeItem(stringBuilder, iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append('$');
        }
        return new ASN1OctetString(stringBuilder.toString());
    }

    @Override
    public ASN1OctetString normalizeSubstring(ASN1OctetString aSN1OctetString, byte by) throws LDAPException {
        return CaseIgnoreStringMatchingRule.getInstance().normalizeSubstring(aSN1OctetString, by);
    }

    public static List<String> getItems(ASN1OctetString aSN1OctetString) throws LDAPException {
        return CaseIgnoreListMatchingRule.getItems(aSN1OctetString.stringValue());
    }

    public static List<String> getItems(String string) throws LDAPException {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                try {
                    stringBuilder.append(CaseIgnoreListMatchingRule.decodeHexChar(string, i + 1));
                    i += 2;
                    continue;
                }
                catch (Exception exception) {
                    Debug.debugException(exception);
                    throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_CASE_IGNORE_LIST_MALFORMED_HEX_CHAR.get(string), exception);
                }
            }
            if (c == '$') {
                String string2 = stringBuilder.toString().trim();
                if (string2.length() == 0) {
                    throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_CASE_IGNORE_LIST_EMPTY_ITEM.get(string));
                }
                arrayList.add(string2);
                stringBuilder.delete(0, stringBuilder.length());
                continue;
            }
            stringBuilder.append(c);
        }
        String string3 = stringBuilder.toString().trim();
        if (string3.length() == 0) {
            if (arrayList.isEmpty()) {
                throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_CASE_IGNORE_LIST_EMPTY_LIST.get(string));
            }
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_CASE_IGNORE_LIST_EMPTY_ITEM.get(string));
        }
        arrayList.add(string3);
        return Collections.unmodifiableList(arrayList);
    }

    public static List<String> getLowercaseItems(ASN1OctetString aSN1OctetString) throws LDAPException {
        return CaseIgnoreListMatchingRule.getLowercaseItems(aSN1OctetString.stringValue());
    }

    public static List<String> getLowercaseItems(String string) throws LDAPException {
        return CaseIgnoreListMatchingRule.getItems(StaticUtils.toLowerCase(string));
    }

    static void normalizeItem(StringBuilder stringBuilder, String string) {
        int n = string.length();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                stringBuilder.append("\\5c");
                bl = false;
                continue;
            }
            if (c == '$') {
                stringBuilder.append("\\24");
                bl = false;
                continue;
            }
            if (c == ' ') {
                if (bl) continue;
                stringBuilder.append(' ');
                bl = true;
                continue;
            }
            stringBuilder.append(c);
            bl = false;
        }
    }

    static char decodeHexChar(String string, int n) throws LDAPException {
        char c = '\u0000';
        int n2 = 0;
        int n3 = n;
        while (n2 < 2) {
            c = (char)(c << 4);
            switch (string.charAt(n3)) {
                case '0': {
                    break;
                }
                case '1': {
                    c = (char)(c | '\u0001');
                    break;
                }
                case '2': {
                    c = (char)(c | 2);
                    break;
                }
                case '3': {
                    c = (char)(c | 3);
                    break;
                }
                case '4': {
                    c = (char)(c | 4);
                    break;
                }
                case '5': {
                    c = (char)(c | 5);
                    break;
                }
                case '6': {
                    c = (char)(c | 6);
                    break;
                }
                case '7': {
                    c = (char)(c | 7);
                    break;
                }
                case '8': {
                    c = (char)(c | 8);
                    break;
                }
                case '9': {
                    c = (char)(c | 9);
                    break;
                }
                case 'A': 
                case 'a': {
                    c = (char)(c | 0xA);
                    break;
                }
                case 'B': 
                case 'b': {
                    c = (char)(c | 0xB);
                    break;
                }
                case 'C': 
                case 'c': {
                    c = (char)(c | 0xC);
                    break;
                }
                case 'D': 
                case 'd': {
                    c = (char)(c | 0xD);
                    break;
                }
                case 'E': 
                case 'e': {
                    c = (char)(c | 0xE);
                    break;
                }
                case 'F': 
                case 'f': {
                    c = (char)(c | 0xF);
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_CASE_IGNORE_LIST_NOT_HEX_DIGIT.get(Character.valueOf(string.charAt(n3))));
                }
            }
            ++n2;
            ++n3;
        }
        return c;
    }
}

