/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.matchingrules;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.AcceptAllSimpleMatchingRule;
import com.unboundid.util.StaticUtils;

public final class CaseIgnoreStringMatchingRule
extends AcceptAllSimpleMatchingRule {
    private static final CaseIgnoreStringMatchingRule INSTANCE = new CaseIgnoreStringMatchingRule();
    public static final String EQUALITY_RULE_NAME = "caseIgnoreMatch";
    static final String LOWER_EQUALITY_RULE_NAME = StaticUtils.toLowerCase("caseIgnoreMatch");
    public static final String EQUALITY_RULE_OID = "2.5.13.2";
    public static final String ORDERING_RULE_NAME = "caseIgnoreOrderingMatch";
    static final String LOWER_ORDERING_RULE_NAME = StaticUtils.toLowerCase("caseIgnoreOrderingMatch");
    public static final String ORDERING_RULE_OID = "2.5.13.3";
    public static final String SUBSTRING_RULE_NAME = "caseIgnoreSubstringsMatch";
    static final String LOWER_SUBSTRING_RULE_NAME = StaticUtils.toLowerCase("caseIgnoreSubstringsMatch");
    public static final String SUBSTRING_RULE_OID = "2.5.13.4";
    private static final long serialVersionUID = -1293370922676445525L;

    public static CaseIgnoreStringMatchingRule getInstance() {
        return INSTANCE;
    }

    public String getEqualityMatchingRuleName() {
        return EQUALITY_RULE_NAME;
    }

    public String getEqualityMatchingRuleOID() {
        return EQUALITY_RULE_OID;
    }

    public String getOrderingMatchingRuleName() {
        return ORDERING_RULE_NAME;
    }

    public String getOrderingMatchingRuleOID() {
        return ORDERING_RULE_OID;
    }

    public String getSubstringMatchingRuleName() {
        return SUBSTRING_RULE_NAME;
    }

    public String getSubstringMatchingRuleOID() {
        return SUBSTRING_RULE_OID;
    }

    public boolean valuesMatch(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2) {
        byte[] byArray;
        byte[] byArray2 = aSN1OctetString.getValue();
        if (byArray2.length == (byArray = aSN1OctetString2.getValue()).length) {
            for (int i = 0; i < byArray2.length; ++i) {
                char c;
                byte by = byArray2[i];
                byte by2 = byArray[i];
                if ((by & 0x7F) != (by & 0xFF) || (by2 & 0x7F) != (by2 & 0xFF)) {
                    return this.normalize(aSN1OctetString).equals(this.normalize(aSN1OctetString2));
                }
                if (by == by2) continue;
                if (by == 32 || by2 == 32) {
                    return this.normalize(aSN1OctetString).equals(this.normalize(aSN1OctetString2));
                }
                if (Character.isUpperCase((char)by)) {
                    c = Character.toLowerCase((char)by);
                    if (c == (char)by2) continue;
                    return false;
                }
                if (Character.isUpperCase((char)by2)) {
                    c = Character.toLowerCase((char)by2);
                    if (c == (char)by) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return CaseIgnoreStringMatchingRule.normalizeInternal(aSN1OctetString, false, (byte)0).equals(CaseIgnoreStringMatchingRule.normalizeInternal(aSN1OctetString2, false, (byte)0));
    }

    public ASN1OctetString normalize(ASN1OctetString aSN1OctetString) {
        return CaseIgnoreStringMatchingRule.normalizeInternal(aSN1OctetString, false, (byte)0);
    }

    public ASN1OctetString normalizeSubstring(ASN1OctetString aSN1OctetString, byte by) {
        return CaseIgnoreStringMatchingRule.normalizeInternal(aSN1OctetString, true, by);
    }

    private static ASN1OctetString normalizeInternal(ASN1OctetString aSN1OctetString, boolean bl, byte by) {
        int n;
        boolean bl2;
        boolean bl3;
        byte[] byArray = aSN1OctetString.getValue();
        if (byArray.length == 0) {
            return aSN1OctetString;
        }
        if (bl) {
            switch (by) {
                case -128: {
                    bl3 = true;
                    bl2 = false;
                    break;
                }
                case -126: {
                    bl3 = false;
                    bl2 = true;
                    break;
                }
                default: {
                    bl3 = false;
                    bl2 = false;
                    break;
                }
            }
        } else {
            bl3 = true;
            bl2 = true;
        }
        boolean bl4 = false;
        boolean bl5 = bl3;
        int n2 = 0;
        byte[] byArray2 = byArray;
        int n3 = byArray2.length;
        for (n = 0; n < n3; ++n) {
            byte by2 = byArray2[n];
            if ((by2 & 0x7F) != (by2 & 0xFF)) {
                return CaseIgnoreStringMatchingRule.normalizeNonASCII(aSN1OctetString, bl3, bl2);
            }
            if (by2 == 32) {
                if (bl5) {
                    ++n2;
                    continue;
                }
                bl5 = true;
                continue;
            }
            bl4 = true;
            bl5 = false;
        }
        if (!bl4) {
            return new ASN1OctetString(" ");
        }
        if (bl5 && bl2) {
            ++n2;
        }
        bl5 = bl3;
        int n4 = 0;
        byte[] byArray3 = new byte[byArray.length - n2];
        block34: for (n = 0; n < byArray.length; ++n) {
            switch (byArray[n]) {
                case 32: {
                    if (bl5 || bl2 && n == byArray.length - 1 || n4 >= byArray3.length) continue block34;
                    byArray3[n4++] = 32;
                    bl5 = true;
                    continue block34;
                }
                case 65: {
                    byArray3[n4++] = 97;
                    bl5 = false;
                    continue block34;
                }
                case 66: {
                    byArray3[n4++] = 98;
                    bl5 = false;
                    continue block34;
                }
                case 67: {
                    byArray3[n4++] = 99;
                    bl5 = false;
                    continue block34;
                }
                case 68: {
                    byArray3[n4++] = 100;
                    bl5 = false;
                    continue block34;
                }
                case 69: {
                    byArray3[n4++] = 101;
                    bl5 = false;
                    continue block34;
                }
                case 70: {
                    byArray3[n4++] = 102;
                    bl5 = false;
                    continue block34;
                }
                case 71: {
                    byArray3[n4++] = 103;
                    bl5 = false;
                    continue block34;
                }
                case 72: {
                    byArray3[n4++] = 104;
                    bl5 = false;
                    continue block34;
                }
                case 73: {
                    byArray3[n4++] = 105;
                    bl5 = false;
                    continue block34;
                }
                case 74: {
                    byArray3[n4++] = 106;
                    bl5 = false;
                    continue block34;
                }
                case 75: {
                    byArray3[n4++] = 107;
                    bl5 = false;
                    continue block34;
                }
                case 76: {
                    byArray3[n4++] = 108;
                    bl5 = false;
                    continue block34;
                }
                case 77: {
                    byArray3[n4++] = 109;
                    bl5 = false;
                    continue block34;
                }
                case 78: {
                    byArray3[n4++] = 110;
                    bl5 = false;
                    continue block34;
                }
                case 79: {
                    byArray3[n4++] = 111;
                    bl5 = false;
                    continue block34;
                }
                case 80: {
                    byArray3[n4++] = 112;
                    bl5 = false;
                    continue block34;
                }
                case 81: {
                    byArray3[n4++] = 113;
                    bl5 = false;
                    continue block34;
                }
                case 82: {
                    byArray3[n4++] = 114;
                    bl5 = false;
                    continue block34;
                }
                case 83: {
                    byArray3[n4++] = 115;
                    bl5 = false;
                    continue block34;
                }
                case 84: {
                    byArray3[n4++] = 116;
                    bl5 = false;
                    continue block34;
                }
                case 85: {
                    byArray3[n4++] = 117;
                    bl5 = false;
                    continue block34;
                }
                case 86: {
                    byArray3[n4++] = 118;
                    bl5 = false;
                    continue block34;
                }
                case 87: {
                    byArray3[n4++] = 119;
                    bl5 = false;
                    continue block34;
                }
                case 88: {
                    byArray3[n4++] = 120;
                    bl5 = false;
                    continue block34;
                }
                case 89: {
                    byArray3[n4++] = 121;
                    bl5 = false;
                    continue block34;
                }
                case 90: {
                    byArray3[n4++] = 122;
                    bl5 = false;
                    continue block34;
                }
                default: {
                    byArray3[n4++] = byArray[n];
                    bl5 = false;
                }
            }
        }
        return new ASN1OctetString(byArray3);
    }

    private static ASN1OctetString normalizeNonASCII(ASN1OctetString aSN1OctetString, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder(aSN1OctetString.stringValue());
        int n = 0;
        boolean bl3 = bl;
        while (n < stringBuilder.length()) {
            char c;
            if ((c = stringBuilder.charAt(n++)) == ' ') {
                if (bl3 || bl2 && n >= stringBuilder.length()) {
                    stringBuilder.deleteCharAt(--n);
                    continue;
                }
                bl3 = true;
                continue;
            }
            if (Character.isUpperCase(c)) {
                stringBuilder.setCharAt(n - 1, Character.toLowerCase(c));
            }
            bl3 = false;
        }
        if (bl2 && stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == ' ') {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return new ASN1OctetString(stringBuilder.toString());
    }
}

