/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.matchingrules;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.matchingrules.MatchingRuleMessages;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;

public final class DistinguishedNameMatchingRule
extends MatchingRule {
    private static final DistinguishedNameMatchingRule INSTANCE = new DistinguishedNameMatchingRule();
    public static final String EQUALITY_RULE_NAME = "distinguishedNameMatch";
    static final String LOWER_EQUALITY_RULE_NAME = StaticUtils.toLowerCase("distinguishedNameMatch");
    public static final String EQUALITY_RULE_OID = "2.5.13.1";
    private static final long serialVersionUID = -2617356571703597868L;

    public static DistinguishedNameMatchingRule getInstance() {
        return INSTANCE;
    }

    public String getEqualityMatchingRuleName() {
        return EQUALITY_RULE_NAME;
    }

    public String getEqualityMatchingRuleOID() {
        return EQUALITY_RULE_OID;
    }

    public String getOrderingMatchingRuleName() {
        return null;
    }

    public String getOrderingMatchingRuleOID() {
        return null;
    }

    public String getSubstringMatchingRuleName() {
        return null;
    }

    public String getSubstringMatchingRuleOID() {
        return null;
    }

    public boolean valuesMatch(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2) throws LDAPException {
        DN dN;
        DN dN2;
        try {
            dN2 = new DN(aSN1OctetString.stringValue());
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, lDAPException.getMessage(), lDAPException);
        }
        try {
            dN = new DN(aSN1OctetString2.stringValue());
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, lDAPException.getMessage(), lDAPException);
        }
        return dN2.equals(dN);
    }

    public boolean matchesSubstring(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2, ASN1OctetString[] aSN1OctetStringArray, ASN1OctetString aSN1OctetString3) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_DN_SUBSTRING_MATCHING_NOT_SUPPORTED.get());
    }

    public int compareValues(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_DN_ORDERING_MATCHING_NOT_SUPPORTED.get());
    }

    public ASN1OctetString normalize(ASN1OctetString aSN1OctetString) throws LDAPException {
        try {
            DN dN = new DN(aSN1OctetString.stringValue());
            return new ASN1OctetString(dN.toNormalizedString());
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, lDAPException.getMessage(), lDAPException);
        }
    }

    public ASN1OctetString normalizeSubstring(ASN1OctetString aSN1OctetString, byte by) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_DN_SUBSTRING_MATCHING_NOT_SUPPORTED.get());
    }
}

