/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.matchingrules;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.matchingrules.MatchingRuleMessages;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.StaticUtils;

public final class IntegerMatchingRule
extends MatchingRule {
    private static final IntegerMatchingRule INSTANCE = new IntegerMatchingRule();
    public static final String EQUALITY_RULE_NAME = "integerMatch";
    static final String LOWER_EQUALITY_RULE_NAME = StaticUtils.toLowerCase("integerMatch");
    public static final String EQUALITY_RULE_OID = "2.5.13.14";
    public static final String ORDERING_RULE_NAME = "integerOrderingMatch";
    static final String LOWER_ORDERING_RULE_NAME = StaticUtils.toLowerCase("integerOrderingMatch");
    public static final String ORDERING_RULE_OID = "2.5.13.15";
    private static final long serialVersionUID = -9056942146971528818L;

    public static IntegerMatchingRule getInstance() {
        return INSTANCE;
    }

    public String getEqualityMatchingRuleName() {
        return EQUALITY_RULE_NAME;
    }

    public String getEqualityMatchingRuleOID() {
        return EQUALITY_RULE_OID;
    }

    public String getOrderingMatchingRuleName() {
        return ORDERING_RULE_NAME;
    }

    public String getOrderingMatchingRuleOID() {
        return ORDERING_RULE_OID;
    }

    public String getSubstringMatchingRuleName() {
        return null;
    }

    public String getSubstringMatchingRuleOID() {
        return null;
    }

    public boolean valuesMatch(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2) throws LDAPException {
        return this.normalize(aSN1OctetString).equals(this.normalize(aSN1OctetString2));
    }

    public boolean matchesSubstring(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2, ASN1OctetString[] aSN1OctetStringArray, ASN1OctetString aSN1OctetString3) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_INTEGER_SUBSTRING_MATCHING_NOT_SUPPORTED.get());
    }

    public int compareValues(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2) throws LDAPException {
        byte[] byArray = this.normalize(aSN1OctetString).getValue();
        byte[] byArray2 = this.normalize(aSN1OctetString2).getValue();
        if (byArray[0] == 45) {
            if (byArray2[0] == 45) {
                if (byArray.length < byArray2.length) {
                    return 1;
                }
                if (byArray.length > byArray2.length) {
                    return -1;
                }
                for (int i = 1; i < byArray.length; ++i) {
                    int n = byArray2[i] - byArray[i];
                    if (n == 0) continue;
                    return n;
                }
                return 0;
            }
            return -1;
        }
        if (byArray2[0] == 45) {
            return 1;
        }
        if (byArray.length < byArray2.length) {
            return -1;
        }
        if (byArray.length > byArray2.length) {
            return 1;
        }
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] - byArray2[i];
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    public ASN1OctetString normalize(ASN1OctetString aSN1OctetString) throws LDAPException {
        byte[] byArray = aSN1OctetString.getValue();
        if (byArray.length == 0) {
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_INTEGER_ZERO_LENGTH_NOT_ALLOWED.get());
        }
        if (byArray[0] == 32 || byArray[byArray.length - 1] == 32) {
            String string = aSN1OctetString.stringValue().trim();
            if (string.length() == 0) {
                throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_INTEGER_ZERO_LENGTH_NOT_ALLOWED.get());
            }
            block10: for (int i = 0; i < string.length(); ++i) {
                switch (string.charAt(i)) {
                    case '-': {
                        if (i == 0 && string.length() != 1) continue block10;
                        throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_INTEGER_INVALID_CHARACTER.get());
                    }
                    case '0': {
                        if ((i != 0 || string.length() <= 1) && (i != 1 || string.charAt(0) != '-')) continue block10;
                        throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_INTEGER_INVALID_LEADING_ZERO.get());
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        continue block10;
                    }
                    default: {
                        throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_INTEGER_INVALID_CHARACTER.get(i));
                    }
                }
            }
            return new ASN1OctetString(string);
        }
        block11: for (int i = 0; i < byArray.length; ++i) {
            switch (byArray[i]) {
                case 45: {
                    if (i == 0 && byArray.length != 1) continue block11;
                    throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_INTEGER_INVALID_CHARACTER.get());
                }
                case 48: {
                    if ((i != 0 || byArray.length <= 1) && (i != 1 || byArray[0] != 45)) continue block11;
                    throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_INTEGER_INVALID_LEADING_ZERO.get());
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    continue block11;
                }
                default: {
                    throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_INTEGER_INVALID_CHARACTER.get(i));
                }
            }
        }
        return aSN1OctetString;
    }

    public ASN1OctetString normalizeSubstring(ASN1OctetString aSN1OctetString, byte by) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_INTEGER_SUBSTRING_MATCHING_NOT_SUPPORTED.get());
    }
}

